/* this version of the EMD uses Rubner's code */
#include "emd-rubner.h"

#include <stdlib.h>

#define R_NO_REMAP 1
#define USE_RINTERNALS 1
#include <Rinternals.h>

SEXP emd_r(SEXP sBase, SEXP sCur, SEXP sExtra, SEXP sFlows) {
  SEXP sBaseDim = Rf_getAttrib(sBase, R_DimSymbol);
  SEXP sCurDim = Rf_getAttrib(sCur, R_DimSymbol);
  if (sBaseDim == R_NilValue || LENGTH(sBaseDim) != 2) Rf_error("base must be a matrix");
  if (sCurDim  == R_NilValue || LENGTH(sCurDim)  != 2) Rf_error("cur must be a matrix");
  int *baseDim = INTEGER(sBaseDim);
  int *curDim = INTEGER(sCurDim);
  int baseRows = baseDim[0], baseCol = baseDim[1];
  int curRows = curDim[0], curCol = curDim[1];
  sBase = Rf_coerceVector(sBase, REALSXP);
  sCur = Rf_coerceVector(sCur, REALSXP);
  double *baseVal = REAL(sBase);
  double *curVal = REAL(sCur);
  flow_t *flows = NULL;
  int n_flows = 0;

  if (baseCol != curCol) Rf_error("base and current sets must have the same dimensionality");
  if (baseCol < 2) Rf_error("at least two columns (weight and location) are required");
  if (baseCol > FDIM + 1) Rf_warning("more than %d dimensions are used, those will be ignored", FDIM);

  signature_t baseSig, curSig;
  
  baseSig.n = baseRows;
  baseSig.Features = (feature_t*) R_alloc(baseRows, sizeof(feature_t));
  baseSig.Weights  = (float*) R_alloc(baseRows, sizeof(float));
  curSig.n = curRows;
  curSig.Features = (feature_t*) R_alloc(curRows, sizeof(feature_t));
  curSig.Weights  = (float*) R_alloc(curRows, sizeof(float));

  int i, j;
  for (i = 0; i < baseRows; i++) {
    for (j = 0; j < FDIM; j++)
      baseSig.Features[i].loc[j] = (j + 1 < baseCol) ? baseVal[i + (j + 1) * baseRows] : 0.0;
    baseSig.Weights[i] = baseVal[i];
  }
  for (i = 0; i < curRows; i++) {
    for (j = 0; j < FDIM; j++)
      curSig.Features[i].loc[j] = (j + 1 < curCol) ? curVal[i + (j + 1) * curRows] : 0.0;
    curSig.Weights[i] = curVal[i];
  }
  
  if (Rf_asLogical(sFlows) == TRUE) {
      flows = malloc(sizeof(flow_t) * (baseRows + curRows - 1));
      if (!flows)
	  Rf_error("unable to allocate memory for flows");
  }

  double d = emd_rubner(&baseSig, &curSig, flows, flows ? &n_flows : NULL, Rf_asInteger(sExtra));
  
  if (!flows)
      return Rf_ScalarReal(d);

  SEXP res = PROTECT(Rf_ScalarReal(d));
  SEXP fl = PROTECT(Rf_allocVector(VECSXP, 3)); /* must protect due to install() */
  Rf_setAttrib(res, Rf_install("flows"), fl);
  UNPROTECT(1);
  SEXP f_from = Rf_allocVector(INTSXP, n_flows);  SET_VECTOR_ELT(fl, 0, f_from);
  SEXP f_to   = Rf_allocVector(INTSXP, n_flows);  SET_VECTOR_ELT(fl, 1, f_to);
  SEXP f_amt  = Rf_allocVector(REALSXP, n_flows); SET_VECTOR_ELT(fl, 2, f_amt);
  int * i_from = INTEGER(f_from), * i_to = INTEGER(f_to);
  double * r_amt = REAL(f_amt);
  
  for (i = 0; i < n_flows; i++) {
      i_from[i] = flows[i].from;
      i_to[i]   = flows[i].to;
      r_amt[i]  = flows[i].amount;
  }
  free(flows);
  
  UNPROTECT(1);
  return res;
}
