% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat.r
\name{cat}
\alias{cat}
\alias{cat_}
\alias{cat_aliases}
\alias{cat_allocation}
\alias{cat_count}
\alias{cat_segments}
\alias{cat_health}
\alias{cat_indices}
\alias{cat_master}
\alias{cat_nodes}
\alias{cat_nodeattrs}
\alias{cat_pending_tasks}
\alias{cat_plugins}
\alias{cat_recovery}
\alias{cat_thread_pool}
\alias{cat_shards}
\alias{cat_fielddata}
\title{Use the cat Elasticsearch api.}
\usage{
cat_(conn, parse = FALSE, ...)

cat_aliases(conn, verbose = FALSE, index = NULL, h = NULL,
  help = FALSE, bytes = FALSE, parse = FALSE, ...)

cat_allocation(conn, verbose = FALSE, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_count(conn, verbose = FALSE, index = NULL, h = NULL,
  help = FALSE, bytes = FALSE, parse = FALSE, ...)

cat_segments(conn, verbose = FALSE, index = NULL, h = NULL,
  help = FALSE, bytes = FALSE, parse = FALSE, ...)

cat_health(conn, verbose = FALSE, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_indices(conn, verbose = FALSE, index = NULL, h = NULL,
  help = FALSE, bytes = FALSE, parse = FALSE, ...)

cat_master(conn, verbose = FALSE, index = NULL, h = NULL,
  help = FALSE, bytes = FALSE, parse = FALSE, ...)

cat_nodes(conn, verbose = FALSE, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_nodeattrs(conn, verbose = FALSE, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_pending_tasks(conn, verbose = FALSE, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_plugins(conn, verbose = FALSE, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_recovery(conn, verbose = FALSE, index = NULL, h = NULL,
  help = FALSE, bytes = FALSE, parse = FALSE, ...)

cat_thread_pool(conn, verbose = FALSE, index = NULL, h = NULL,
  help = FALSE, bytes = FALSE, parse = FALSE, ...)

cat_shards(conn, verbose = FALSE, index = NULL, h = NULL,
  help = FALSE, bytes = FALSE, parse = FALSE, ...)

cat_fielddata(conn, verbose = FALSE, index = NULL, fields = NULL,
  h = NULL, help = FALSE, bytes = FALSE, parse = FALSE, ...)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{parse}{(logical) Parse to a data.frame or not. Default: \code{FALSE}}

\item{...}{Curl args passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{verbose}{(logical) If \code{TRUE} (default) the url call used printed to console}

\item{index}{(character) Index name}

\item{h}{(character) Fields to return}

\item{help}{(logical) Output available columns, and their meanings}

\item{bytes}{(logical) Give numbers back machine friendly. Default: \code{FALSE}}

\item{fields}{(character) Fields to return, only used with \code{fielddata}}
}
\description{
Use the cat Elasticsearch api.
}
\details{
See \url{https://www.elastic.co/guide/en/elasticsearch/reference/current/cat.html}
for the cat API documentation.

Note how \code{\link[=cat_]{cat_()}} has an underscore at the end to avoid conflict with the function
\code{\link[base:cat]{base::cat()}} in base R.
}
\examples{
\dontrun{
# connection setup
(x <- connect())

# list Elasticsearch cat endpoints
cat_(x)

# Do other cat operations
cat_aliases(x)
cat_aliases(x, index='plos')
cat_allocation(x)
cat_allocation(x, verbose=TRUE)
cat_count(x)
cat_count(x, index='plos')
cat_count(x, index='gbif')
cat_segments(x)
cat_segments(x, index='gbif')
cat_health(x)
cat_indices(x)
cat_master(x)
cat_nodes(x)
# cat_nodeattrs(x) # not available in older ES versions
cat_pending_tasks(x)
cat_plugins(x)
cat_recovery(x, verbose=TRUE)
cat_recovery(x, index='gbif')
cat_thread_pool(x)
cat_thread_pool(x, verbose=TRUE)
cat_shards(x)
cat_fielddata(x)
cat_fielddata(x, fields='body')

# capture cat data into a data.frame
cat_(x, parse = TRUE)
cat_indices(x, parse = TRUE)
cat_indices(x, parse = TRUE, verbose = TRUE)
cat_count(x, parse = TRUE)
cat_count(x, parse = TRUE, verbose = TRUE)
cat_health(x, parse = TRUE)
cat_health(x, parse = TRUE, verbose = TRUE)

# Get help - what does each column mean
head(cat_indices(x, help = TRUE, parse = TRUE))
cat_health(x, help = TRUE, parse = TRUE)
head(cat_nodes(x, help = TRUE, parse = TRUE))

# Get back only certain fields
cat_nodes(x)
cat_nodes(x, h = c('ip','port','heapPercent','name'))
cat_nodes(x, h = c('id', 'ip', 'port', 'v', 'm'))
cat_indices(x, verbose = TRUE)
cat_indices(x, verbose = TRUE, h = c('index','docs.count','store.size'))

# Get back machine friendly numbers instead of the normal human friendly
cat_indices(x, verbose = TRUE, bytes = TRUE)

# Curl options
# cat_count(x, timeout_ms = 1)
}
}
