% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elaborator_plot_quant_trends.R
\name{elaborator_plot_quant_trends}
\alias{elaborator_plot_quant_trends}
\title{elaborator_plot_quant_trends - Function to draw Boxplots for each Treatment and Labparameter}
\usage{
elaborator_plot_quant_trends(
  dat1,
  signtest = TRUE,
  Visit1,
  Visit2,
  sameaxes = FALSE,
  ats = NULL,
  cols = NULL,
  labelvis = NULL,
  labcolumn,
  sortpoints = FALSE,
  pcutoff = 0.01,
  cexoutliers = 0.7,
  infotest = NULL,
  sortinput = as.character(unique(dat1[, labcolumn])),
  bordercol = NULL,
  add_points = TRUE,
  connect_lines = FALSE
)
}
\arguments{
\item{dat1}{data set}

\item{signtest}{boolean value if signtest should be performded (TRUE/FALSE)}

\item{Visit1}{visit time point one}

\item{Visit2}{visit time point two}

\item{sameaxes}{boolean value if boxplot should have the same y-axis for the treatments within a labparameter}

\item{ats}{ats parameter}

\item{cols}{colors of boxplots}

\item{labelvis}{visibility of labels}

\item{labcolumn}{labparameter column}

\item{sortpoints}{boolean value if dots in boxplot should be sorted}

\item{pcutoff}{limit for p-values were the background should be colored}

\item{cexoutliers}{size of the outliers}

\item{infotest}{List object from the perform test function.}

\item{sortinput}{sorting rule}

\item{bordercol}{color of boxes which are not selected to perform a test}

\item{add_points}{boolean value if points should be added to the Boxplots (TRUE/FALSE)}

\item{connect_lines}{boolean value if subject values should be connected via lines (TRUE/FALSE)}
}
\description{
elaborator_plot_quant_trends - Function to draw Boxplots for each Treatment and Labparameter
}
\keyword{internal}
