% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eicm-options.r
\name{as.eicm}
\alias{as.eicm}
\title{Define a parameterized EICM model}
\usage{
as.eicm(env.coefs, sp.coefs = NULL, latent = NULL, options = NULL,
  occurrences = NULL, env = NULL, traits = NULL, intercept = TRUE,
  regularization = NULL)
}
\arguments{
\item{env.coefs}{the environmental coefficient matrix: a species x variable matrix (including intercept).}

\item{sp.coefs}{the species interaction coefficient matrix: a species x species matrix, with zero diagonal.}

\item{latent}{the values for the latent variables in each sample: a sample x latent variable matrix.}

\item{options}{a \code{eicm.options} object defining options for fitting. Usually not needed, use
\code{forbidden}, \code{mask.sp} and \code{exclude.prevalence} instead.}

\item{occurrences}{a binary (0/1) sample x species matrix, possibly including NAs.}

\item{env}{an optional sample x environmental variable matrix, for the known environmental predictors.}

\item{traits}{an optional species x trait matrix. Currently, it is only used for excluding
species interactions \emph{a priori}.}

\item{intercept}{logical specifying whether to add a column for the species-level intercepts.}

\item{regularization}{a two-element numeric vector defining the regularization lambdas used for
environmental coefficients and for species interactions respectively. See details.}
}
\value{
A \code{eicm} object that can be used for prediction.
}
\description{
Constructs a EICM model object from given coefficients and data. Useful for simulating "true" models,
otherwise only used internally.
}
\details{
\code{regularization} is only used for storing the regularization lambdas used in model fitting.
It is ignored in simulation.
}
\note{
This function is only useful for simulation purposes. If you want to predict values from a fitted model,
a \code{eicm} object is already provided for the fitted model.
}
\examples{
# Generate some coefficients
nenv <- 2
nsp <- 20
nsamples <- 200

env <- matrix(rnorm(nenv * nsamples), ncol=nenv, nrow=nsamples)
env.coefs <- matrix(runif((nenv + 1) * nsp, -4, 4), nrow=nsp)
sp.coefs <- matrix(0, nrow=nsp, ncol=nsp)
sp.coefs[3, 5] <- 3
sp.coefs[4, 8] <- 2

# Define a true model (including environmental data)
truemodel <- as.eicm(env=env, env.coefs=env.coefs, sp.coefs=sp.coefs)

# We can now realize it
predict(truemodel)
}
\seealso{
\code{\link{predict.eicm}}
}
