% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grs.R
\name{grs}
\alias{grs}
\title{Guided Random Search}
\usage{
grs(D, d)
}
\arguments{
\item{D}{An nxn partial-distance matrix to be completed. D must satisfy a list of conditions (see details), with unkown entries set to NA}

\item{d}{The dimension for the resulting completion.}
}
\value{
\item{P   }{The completed point configuration in dimension d}
\item{D   }{The completed Euclidean distance matrix}
}
\description{
\code{grs} performs Euclidean Distance Matrix Completion using the guided random search algorithm
of Rahman & Oldford. Using this method will preserve the minimum spanning tree in the partial distance 
matrix.
}
\details{
The matrix D is a partial-distance matrix, meaning some of its entries are unknown. 
It must satisfy the following conditions in order to be completed:
\itemize{
\item{diag(D) = 0}
\item{If \eqn{a_{ij}} is known, \eqn{a_{ji} = a_{ij}}}
\item{If \eqn{a_{ij}} is unknown, so is \eqn{a_{ji}}}
\item{The graph of D must contain ONLY the minimum spanning tree distances}
}
}
\examples{
#D matrix containing only the minimum spanning tree
D <- matrix(c(0,3,NA,3,NA,NA,
              3,0,1,NA,NA,NA,
              NA,1,0,NA,NA,NA,
              3,NA,NA,0,1,NA,
              NA,NA,NA,1,0,1,
              NA,NA,NA,NA,1,0),byrow=TRUE, nrow=6)
              
edmc(D, method="grs", d=3)

}
\references{
Rahman, D., & Oldford, R.W. (2016). Euclidean Distance Matrix Completion and Point Configurations from the Minimal Spanning Tree.
}

