% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_prox}
\alias{plot_prox}
\title{Plot principle components of the proximity matrix}
\usage{
plot_prox(pca, dims = 1:2, labels = NULL, alpha = 1, alpha_label = NULL,
  color = "black", color_label = NULL, shape = "1", shape_label = NULL,
  size = 2, size_label = NULL, xlab = NULL, ylab = NULL, title = "")
}
\arguments{
\item{pca}{a prcomp object, pca of an n x n matrix giving the proportion of times across all trees that observation i,j are in the same terminal node}

\item{dims}{integer vector of length 2 giving indices for the dimensions of \code{pca} to be plotted}

\item{labels}{length n character vector giving observation labels}

\item{alpha}{optional continuous vector of length n make points/labels transparent or
a numeric of length 1 giving the alpha of all points/labels}

\item{alpha_label}{character legend title if alpha parameter used}

\item{color}{optional discrete vector of length n which colors the points/labels or
a character vector giving the color of all points/labels}

\item{color_label}{character legend title if color parameter is used}

\item{shape}{optional discrete vector of length n which shapes points (not applicable if labels used) or
a character vector of length 1 which gives the shape of all points}

\item{shape_label}{character legend title if shape parameter is used}

\item{size}{optional continuous vector of length n which sizes points or labels or
a numeric of length 1 which gives the sizes of all the points}

\item{size_label}{character legend title if size parameter used}

\item{xlab}{character x-axis label}

\item{ylab}{character y-axis label}

\item{title}{character plot title}
}
\value{
a ggplot object
}
\description{
Plot principle components of the proximity matrix
}
\examples{
library(randomForest)

fit <- randomForest(hp ~ ., mtcars, proximity = TRUE)
prox <- extract_proximity(fit)
pca <- prcomp(prox, scale = TRUE)
plot_prox(pca, labels = row.names(mtcars))

fit <- randomForest(Species ~ ., iris, proximity = TRUE)
prox <- extract_proximity(fit)
pca <- prcomp(prox, scale = TRUE)
plot_prox(pca, color = iris$Species, color_label = "Species", size = 2)
}
\references{
https://github.com/vqv/ggbiplot

Gabriel, "The biplot graphic display of matrices with application to principal component analysis," \emph{Biometrika}, 1971
}

