% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exam2.2.R
\name{Exam2.2}
\alias{Exam2.2}
\title{Example 2.2 from Experimental Design and Analysis for Tree Improvement}
\description{
Exam2.2 is used to  compare two seed lots by using ANOVA under RCB Design.
}
\examples{
library(car)
library(dae)
library(dplyr)
library(emmeans)
library(ggplot2)
library(lmerTest)
library(magrittr)
library(predictmeans)
library(supernova)

data(DataExam2.2)

# Pg. 24
fmtab2.5 <- lm(formula  = dbh ~ Blk + SeedLot, data = DataExam2.2)

# Pg. 26
anova(fmtab2.5)
supernova(fmtab2.5, type = 1)

# Pg. 26
emmeans(object = fmtab2.5, specs = ~ SeedLot)
emmip(object = fmtab2.5, formula = ~ SeedLot) +
  theme_classic()

}
\references{
\enumerate{
         \item E.R. Williams, C.E. Harwood and A.C. Matheson (2023). \emph{Experimental Design and Analysis for Tree Improvement}.
               CSIRO Publishing (\href{https://www.publish.csiro.au/book/3145/}{https://www.publish.csiro.au/book/3145/}).
             }
}
\seealso{
\code{\link{DataExam2.2}}
}
\author{
\enumerate{
         \item  Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item  Sami Ullah (\email{samiullahuos@gmail.com})
         }
}
