% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantify.R
\name{quantify}
\alias{quantify}
\alias{quantify.econet}
\title{quantify: quantification of marginal effects in linear-in-means models.}
\usage{
\method{quantify}{econet}(object, ...)
}
\arguments{
\item{object}{first object in the list of outcomes returned by \code{net_dep} (available only if the argument \code{model} is set to \code{"model_B"}).}

\item{...}{other arguments}
}
\value{
an object of class \code{data.frame} listing direct and indirect variable effects (mean, standard deviation, max, min).
}
\description{
quantify: quantification of marginal effects in linear-in-means models.
}
\details{
\code{quantify} returns marginal effects for \code{net_dep} objects when \code{model = "model_B"} and \code{hypothesis = "lim"}.
For additional details, see the vignette
}
\examples{
\donttest{
# Load data
data("db_cosponsor")
data("G_alumni_111")
db_model_B <- subset(db_cosponsor, time == 3)
G_model_B <- G_cosponsor_111
G_exclusion_restriction <- G_alumni_111
are_factors <- c("party", "gender", "nchair")
db_model_B[are_factors] <- lapply(db_model_B[are_factors], factor)

# Specify formula
f_model_B <- formula("les ~gender + party + nchair")

# Specify starting values
starting <- c(alpha = 0.23952,
              beta_gender1 = -0.22024,
              beta_party1 = 0.42947,
              beta_nchair1 = 3.09615,
              phi = 0.40038,
              unobservables = 0.07714)

# Fit Linear-in-means model
lim_model_B <- net_dep(formula = f_model_B, data = db_model_B,
                       G = G_model_B, model = "model_B", estimation = "NLLS",
                       hypothesis = "lim", endogeneity = TRUE, correction = "heckman",
                       first_step = "standard",
                       exclusion_restriction = G_exclusion_restriction,
                       start.val = starting)
quantify(fit = lim_model_B )
}
# WARNING, This toy example is provided only for runtime execution.
# Please refer to previous examples for sensible calculations.
data("db_alumni_test")
data("G_model_A_test")
db_model <- db_alumni_test
G_model <- G_model_A_test
f_model <- formula("les ~ dw")
lim_model_test <- net_dep(formula = f_model, data = db_model,
                       G = G_model, model = "model_B", estimation = "NLLS",
                       hypothesis = "lim", start.val = c(alpha = 0.4553039,
                                                         beta_dw = -0.7514903,
                                                         phi = 1.6170539))
quantify(lim_model_test)
}
\seealso{
\code{\link{net_dep}}
}
