% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ecr.band}
\alias{ecr.band}
\title{Area band}
\usage{
ecr.band(df = NULL, lower = NULL, upper = NULL, type = "polygon", ...)
}
\arguments{
\item{df}{A data.frame with lower and upper numerical columns and first column with X coordinates.}

\item{lower}{The column name(string) of band's lower boundary.}

\item{upper}{The column name(string) of band's upper boundary.}

\item{type}{Type of rendering  \cr \itemize{
\item 'stack' - by two \href{https://echarts.apache.org/en/option.html#series-line.stack}{stacked lines}
\item 'polygon' - by drawing a polygon as polyline (default). Warning: cannot be zoomed!
}}

\item{...}{More parameters for \href{https://echarts.apache.org/en/option.html#series-line.type}{serie}}
}
\value{
A list of one serie when type='polygon', or two series when type='stack'
}
\description{
A 'custom' serie with lower and upper boundaries
}
\details{
When type='polygon', coordinates of the two boundaries are chained into a polygon and displayed as one.\cr
When type='stack', two \emph{stacked} lines are drawn, one with customizable areaStyle. The upper boundary coordinates should be values added on top of the lower boundary coordinates.\cr
Type 'stack' needs \emph{xAxis} to be of type 'category'.
}
\examples{
if (interactive()) {
df <- airquality |> mutate(lwr= round(Temp-Wind*2),
                           upr= round(Temp+Wind*2),
                           x= paste0(Month,'-',Day) ) |>
                    relocate(x,Temp)
bands <- ecr.band(df, 'lwr', 'upr', type='stack',
                  name='stak', areaStyle= list(opacity=0.4))
df |> ec.init(load='custom',
   legend= list(show= TRUE),
   xAxis= list(type='category', boundaryGap=FALSE),
   series= list(
     list(type='line', color='blue', name='line'),
     bands[[1]], bands[[2]]
   ),
   tooltip= list( trigger= 'axis',
     formatter= ec.clmn(
        'high <b>\%@</b><br>line <b>\%@</b><br>low <b>\%@</b>',
                  3.3, 1.2, 2.2)
     )  # 3.3= upper_serie_index +.+ index_of_column_inside
)
}

}
