% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{assign_to_grid}
\alias{assign_to_grid}
\title{Assign points to a spacetime grid}
\usage{
assign_to_grid(
  points,
  coords = NULL,
  is_lonlat = FALSE,
  res,
  jitter_grid = TRUE,
  grid_definition = NULL
)
}
\arguments{
\item{points}{data frame; points with spatial coordinates \code{x} and \code{y}, and an
optional time coordinate \code{t}.}

\item{coords}{character; names of the spatial and temporal coordinates in the
input dataframe. Only provide these names if you want to overwrite the
default coordinate names: \code{c("x", "y", "t")} or \code{c("longitude", "latitude", "t")} if \code{is_lonlat = TRUE}.}

\item{is_lonlat}{logical; if the points are in unprojected, lon-lat
coordinates. In this case, the input data frame should have columns
\code{"longitude"} and \code{"latitude"} and the points will be projected to an equal
area sinusoidal CRS prior to grid assignment.}

\item{res}{numeric; resolution of the grid in the \code{x}, \code{y}, and \code{t}
dimensions, respectively. If only 2 dimensions are provided, a space only
grid will be generated. The units of \code{res} are the same as the coordinates
in the input data unless \code{is_lonlat} is true in which case the \code{x} and \code{y}
resolution should be provided in meters.}

\item{jitter_grid}{logical; whether to jitter the location of the origin of
the grid to introduce some randomness.}

\item{grid_definition}{list; object defining the grid via the \code{origin} and
\code{resolution} components. To assign multiple sets of points to exactly the
same grid, \code{\link[=assign_to_grid]{assign_to_grid()}} returns a data frame with a \code{grid_definition}
attribute that can be passed to subsequent calls to \code{\link[=assign_to_grid]{assign_to_grid()}}.
\code{res} and \code{jitter} are ignored if \code{grid_definition} is provided.}
}
\value{
Data frame with the indices of the space-only and spacetime grid
cells. This data frame will have a \code{grid_definition} attribute that can be
used to reconstruct the grid.
}
\description{
Given a set of points in space and (optionally) time, define a regular grid
with given dimensions, and return the grid cell index for each point.
}
\examples{
set.seed(1)

# generate some example points
points_xyt <- data.frame(x = runif(100), y = runif(100), t = rnorm(100))
# assign to grid
cells <- assign_to_grid(points_xyt, res = c(0.1, 0.1, 0.5))

# assign a second set of points to the same grid
assign_to_grid(points_xyt, grid_definition = attr(cells, "grid_definition"))

# assign lon-lat points to a 10km space-only grid
points_ll <- data.frame(longitude = runif(100, min = -180, max = 180),
                        latitude = runif(100, min = -90, max = 90))
assign_to_grid(points_ll, res = c(10000, 10000), is_lonlat = TRUE)

# overwrite default coordinate names, 5km by 1 week grid
points_names <- data.frame(lon = runif(100, min = -180, max = 180),
                           lat = runif(100, min = -90, max = 90),
                           day = sample.int(365, size = 100))
assign_to_grid(points_names,
               res = c(5000, 5000, 7),
               coords = c("lon", "lat", "day"),
               is_lonlat = TRUE)
}
