% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defs.r
\name{get.disp.par}
\alias{get.disp.par}
\title{Default list of parameters to control the graphical output during model simulation and via disp.output}
\usage{
get.disp.par(...)
}
\arguments{
\item{...}{Further named arguments supplied will overwrite default values}
}
\value{
List of parameters with default values. These include:
graphics.show Whether to show graphic output. Default TRUE
graphics.window.length Width of display window in hours. Default is 120 days.
graphics.interval Interval between refreshing the graphical output, in hours.
max.q Max discharge (mm/hr) for display
max.rain numeric Max rainfall (mm/hr) for display
lwd.rain numeric Line size for rainfall plot
int.q Interval between ticks / line on the y axis, in mm/hr
int.time Period between ticks on the time axis, a numerical value in hours or one of "day", "week", "month"
prop  Proportion of screen occupied by the rainfall hyteograph
cex   Overall scaling factor of the plot
las.time  Alignment of time axis labels
xmar Size of margin on right and left of plot, inches
ymar Size of margin above and below plot
col  Colours for plot lines: in order, simulated values, observed values
}
\description{
list of parameters to control the graphical output during model
  simulation. Parameters with names corresponding to the graphical
  parameters returned by par() will be applied to the plot.
}
\note{
In this version many of the options are now obsolete. The most relevant are graphics.show and graphics.interval.
}
\examples{
# Enable graphics output and set display interval to 6 hours
par <- get.disp.par(graphics.show=TRUE,
       graphics.interval=6)

}
\author{
Peter Metcalfe
}
