% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.associations-method.R
\name{plot.associations}
\alias{plot.associations}
\title{Plot of \code{associations} objects}
\usage{
\method{plot}{associations}(x, data1, data2, time, feature1, feature2, cutoff,
  fdr = T, absCor = T, withShift = F, ...)
}
\arguments{
\item{x}{an object of class \code{associations}}

\item{data1}{an object of class \code{matrix} or \code{data.frame}.}

\item{data2}{an object of class \code{matrix} or \code{data.frame}.}

\item{time}{a vector of class \code{numeric} presenting the measured time points.}

\item{feature1}{the reference feature to visualise, either the index or the name.}

\item{feature2}{the associated feature to visualise, either the index or the name.}

\item{cutoff}{for the associated feature. If \code{fdr=TRUE} the false discovery rate (fdr) corrected p-value (default \code{cutoff=0.05}). If \code{fdr=FALSE} the absolute Pearson Correlation cutoff (default \code{cutoff=0.9}).}

\item{fdr}{(default TRUE) indicating if the false discovery rate of the corrected p-values from the \code{associations} object should be used as cutoff to visualize associated profiles. If FALSE the absolute Peason correlation is used as cutoff.}

\item{absCor}{(default FALSE) if \code{fdr=FALSE} you can choose to visualise associations invariant for positive or negative correlation.}

\item{withShift}{(default FALSE) indicating if the associated feature should be plotted with the time shift.}

\item{\ldots}{ignored}
}
\value{
plot showing the associated data as calculated by associateData()
}
\description{
Plot showing the associated trajectories with or without estimated time shift.
}
\details{
The function allows to visualise features with and without realignement (or shift) of the time profiles according to the estimated delays using associateData() function from the dynOmics package. Features to be visualised can be filtered either using FDR corrected p-values or a correlation threshold.
}
\examples{
\dontrun{
data(Metabolites)
data(Transcripts)
associations <- associateData(Metabolites[,1:2],Transcripts[,c(1:100)])
#if you only define feature1 or feature2 if will plot all associations
plot(associations,Metabolites,Transcripts,feature1=1,withShift = TRUE)
#if you define feature1 and feature2 it will only plot these two profiles
plot(associations,Metabolites,Transcripts,feature1="Metabolite 1",feature2="Transcript 2")
}
}
\seealso{
\code{\link{associateData}}, \code{\link{summary.associations}}
}
