% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R
\name{duckdb_register}
\alias{duckdb_register}
\alias{duckdb_unregister}
\title{Register a data frame as a virtual table}
\usage{
duckdb_register(conn, name, df, overwrite = FALSE, experimental = FALSE)

duckdb_unregister(conn, name)
}
\arguments{
\item{conn}{A DuckDB connection, created by \code{dbConnect()}.}

\item{name}{The name for the virtual table that is registered or unregistered}

\item{df}{A \code{data.frame} with the data for the virtual table}

\item{overwrite}{Should an existing registration be overwritten?}

\item{experimental}{Enable experimental optimizations}
}
\value{
These functions are called for their side effect.
}
\description{
\code{duckdb_register()} registers a data frame as a virtual table (view)
in a DuckDB connection.
No data is copied.
}
\details{
\code{duckdb_unregister()} unregisters a previously registered data frame.
}
\examples{
con <- dbConnect(duckdb())

data <- data.frame(a = 1:3, b = letters[1:3])

duckdb_register(con, "data", data)
dbReadTable(con, "data")

duckdb_unregister(con, "data")
try(dbReadTable(con, "data"))

dbDisconnect(con)
}
