% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TADPole.R
\name{TADPole}
\alias{TADPole}
\title{TADPole clustering}
\usage{
TADPole(data, window.size = NULL, k = 2, dc, error.check = TRUE)
}
\arguments{
\item{data}{The data matrix where each row is a time series. Optionally a list with each time series.}

\item{window.size}{Window size constraint for DTW. See details.}

\item{k}{The number of desired clusters.}

\item{dc}{The cutoff distance.}

\item{error.check}{Should the data be checked for inconsistencies?}
}
\value{
A list with: \itemize{
  \item \code{cl}: Cluster indices.
  \item \code{centers}: Indices of the centers.
  \item \code{distCalcPercentage}: Percentage of distance calculations that were actually performed.
}
}
\description{
Time-series Anytime Density Peaks Clustering as proposed by Begum et al., 2015.
}
\details{
This function can be called either directly or through \code{\link{dtwclust}}.

TADPole clustering adopts a relatively new clustering framework and adapts it to time series clustering
with DTW. See the cited article for the details of the algorithm.

Because of the way the algorithm works, it can be considered a kind of Partitioning Around Medoids (PAM).
This means that the cluster centers are always elements of the data.

The algorithm first uses the DTW's upper and lower bounds to find series with many close neighbors (in
DTW space). Anything below the cutoff distance (\code{dc}) is considered a neighbor. Aided with this
information, the algorithm then tries to prune as many DTW calculations as possible in order to accelerate
the clustering procedure. The series that lie in dense areas (i.e. that have lots of neighbors) are taken
as cluster centers.

The algorithm relies on the DTW bounds, which are only defined for time series of equal lengths.

The windowing constraint uses a centered window. The calculations expect a value in \code{window.size}
that represents the distance between the point considered and one of the edges of the window. Therefore,
if, for example, \code{window.size = 10}, the warping for an observation \eqn{x_i} considers the points
between \eqn{x_{i-10}} and \eqn{x_{i+10}}, resulting in \code{10*2 + 1 = 21} observations falling within
the window.
}
\references{
Begum N, Ulanova L, Wang J and Keogh E (2015). ``Accelerating Dynamic Time Warping Clustering with a Novel Admissible Pruning
Strategy.'' In \emph{Conference on Knowledge Discovery and Data Mining}, series KDD '15. ISBN 978-1-4503-3664-2/15/08, \url{
http://dx.doi.org/10.1145/2783258.2783286}.
}

