% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/floor.R
\name{dtt_floor}
\alias{dtt_floor}
\alias{dtt_floor.Date}
\alias{dtt_floor.POSIXct}
\alias{dtt_floor.hms}
\title{Floor Date/Time}
\usage{
dtt_floor(x, units, ...)

\method{dtt_floor}{Date}(x, units = "days", ...)

\method{dtt_floor}{POSIXct}(x, units = "seconds", ...)

\method{dtt_floor}{hms}(x, units = "seconds", ...)
}
\arguments{
\item{x}{A date/time vector.}

\item{units}{A string of the time units. The possible values are "secs",
"minutes", "hours", "days" or "weeks".}

\item{...}{Unused.}
}
\value{
The floored date/time vector.
}
\description{
Floors a date/time vector
}
\section{Methods (by class)}{
\itemize{
\item \code{Date}: Floor a Date vector

\item \code{POSIXct}: Floor a POSIXct vector

\item \code{hms}: Floor a hms vector
}}

\examples{
dtt_floor(hms::as_hms("23:59:59"), "hours")
}
\seealso{
Other floor: 
\code{\link{dtt_date_time}()},
\code{\link{dtt_date}()},
\code{\link{dtt_floored}()},
\code{\link{dtt_set_time}()}
}
\concept{floor}
