% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_filter}
\alias{p_filter}
\title{Filtering data}
\usage{
p_filter(
  .data,
  ...,
  .preserve = FALSE,
  .messages = "excluded {.excluded} items",
  .headline = .defaultHeadline(),
  .type = "exclusion",
  .asOffshoot = (.type == "exclusion"),
  .stage = "",
  .tag = NULL
)
}
\arguments{
\item{.data}{\itemize{
\item a dataframe which may be grouped
}}

\item{...}{the filter criteria}

\item{.preserve}{Relevant when the \code{.data} input is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise the grouping is kept as is.}

\item{.messages}{\itemize{
\item a set of glue specs. The glue code can use any global variable, or \{.strata\},\{.count.in\},and \{.count.out\}
}}

\item{.headline}{\itemize{
\item a headline glue spec. The glue code can use any global variable, or \{.strata\},\{.count.in\},and \{.count.out\}
}}

\item{.type}{\itemize{
\item the format type of the action - typically an exclusion
}}

\item{.asOffshoot}{\itemize{
\item if the type is exclusion, asOffshoot places the information box outside of the main flow, as an exclusion.
}}

\item{.stage}{\itemize{
\item a name for this step in the pathway
}}

\item{.tag}{\itemize{
\item if you want the summary data from this step in the future then give it a name with .tag.
}}
}
\value{
the filtered .data dataframe with history graph updated
}
\description{
Filter acts in the same way as DPLYR. Prior to the operation the size of the group is calculated \{.count.in\} and
after the operation the output size \{.count.out\}. The group \{.strata\} is also available (if grouped) for reporting.
See \code{\link[dplyr:filter]{dplyr::filter()}}.
}
\examples{
library(dplyr)
tmp = iris \%>\% track() \%>\% group_by(Species)
tmp \%>\% filter(Petal.Length > 5) \%>\% history()
}
\seealso{
dplyr::filter()
}
