% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{drake_gc}
\alias{drake_gc}
\title{Do garbage collection on the drake cache.
\lifecycle{maturing}}
\usage{
drake_gc(path = NULL, search = NULL, verbose = 1L,
  cache = drake::drake_cache(path = path), force = FALSE)
}
\arguments{
\item{path}{Path to a \code{drake} cache
(usually a hidden \code{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{verbose}{Deprecated on 2019-09-11.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{force}{Logical, whether to load the cache
despite any back compatibility issues with the
running version of drake.}
}
\value{
\code{NULL}
}
\description{
Garbage collection removes obsolete target values
from the cache.
}
\details{
Caution: garbage collection \emph{actually} removes data
so it is no longer recoverable with \code{\link[=drake_history]{drake_history()}} or
\code{make(recover = TRUE)}. You cannot undo this operation.
Use at your own risk.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
# At this point, check the size of the '.drake/' cache folder.
# Clean without garbage collection.
clean(garbage_collection = FALSE)
# The '.drake/' cache folder is still about the same size.
drake_gc() # Do garbage collection on the cache.
# The '.drake/' cache folder should have gotten much smaller.
}
})
}
}
\seealso{
\code{\link[=clean]{clean()}}
}
