% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_keywords.R
\name{target}
\alias{target}
\title{Define custom columns in a \code{\link[=drake_plan]{drake_plan()}}.}
\usage{
target(command = NULL, ...)
}
\arguments{
\item{command}{The command to build the target.}

\item{...}{Named arguments specifying non-standard
fields of the workflow plan.}
}
\value{
A one-row workflow plan data frame with the named
arguments as columns.
}
\description{
Not a user-side function. Please use from within
\code{\link[=drake_plan]{drake_plan()}} only.
}
\section{Keywords}{

\code{\link[=drake_plan]{drake_plan()}} understands special keyword functions for your commands.
With the exception of \code{\link[=target]{target()}}, each one is a proper function
with its own help file.
\itemize{
\item \code{\link[=target]{target()}}: declare more than just the command,
e.g. assign a trigger or transform.
Examples: \url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}. # nolint
\item \code{\link[=file_in]{file_in()}}: declare an input file dependency.
\item \code{\link[=file_out]{file_out()}}: declare an output file to be produced
when the target is built.
\item \code{\link[=knitr_in]{knitr_in()}}: declare a \code{knitr} file dependency such as an
R Markdown (\code{*.Rmd}) or R LaTeX (\code{*.Rnw}) file.
\item \code{\link[=ignore]{ignore()}}: force \code{drake} to entirely ignore a piece of code:
do not track it for changes and do not analyze it for dependencies.
\item \code{\link[=no_deps]{no_deps()}}: tell \code{drake} to not track the dependencies
of a piece of code. \code{drake} still tracks the code itself for changes.
\item \code{\link[=drake_envir]{drake_envir()}}: get the environment where drake builds targets.
Intended for advanced custom memory management.
}
}

\examples{
# Use target() to create your own custom columns in a drake plan.
# See ?triggers for more on triggers.
drake_plan(
  website_data = target(
    download_data("www.your_url.com"),
    trigger = "always",
    custom_column = 5
  ),
  analysis = analyze(website_data)
)
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
\keyword{internal}
