% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock-db.R
\name{mockdb}
\alias{mockdb}
\alias{with_mock_db}
\alias{start_mock_db}
\alias{stop_mock_db}
\title{Run DBI queries against a mocked database}
\usage{
with_mock_db(expr)

start_mock_db()

stop_mock_db()
}
\arguments{
\item{expr}{the expression to execute}
}
\value{
nothing
}
\description{
Wrap a chunk of code in \code{with_mock_db()} to use mocked databases that will
use fixtures instead of connecting to a real database. Alternatively, you can
start and stop using a mocked database with \code{start_mock_db()} and
\code{stop_mock_db()} respectively.to execute the whole thing without needing to
remember to stop the mocking. When testing with {dittodb}, it will look for
fixtures in all entries of \code{\link{db_mock_paths}}.
}
\details{
You only need to use one approach: either use \code{start_mock_db()} to start
using mocks and then \code{stop_mock_db()} to stop or use \code{with_mock_db()} wrapped
around the code you want to execute against the mocked database. You don't
need to (and should not) use both at the same time. Generally
\code{with_mock_db()} is preferred because it is slightly safer and you don't have
to remember to \code{stop_mock_db()} when you're done. However, it is easier to
step through tests interactively using \code{start_mock_db()}/\code{stop_mock_db()}.

Connections should be made after \code{start_mock_db()} if you're using that
function or they should be made inside of \code{with_mock_db()} if you're using
that function because {dittodb} uses the database name (given in \code{dbname} or
\code{Database} argument of \code{\link{dbConnect}} depending on the driver) to separate
different fixtures.
}
\examples{
# Add the mocks included with dittodb to the db_mock_paths to use them below
db_mock_paths(system.file("nycflight_mocks", package = "dittodb"), last = TRUE)

# using  `with_mock_db()`
with_mock_db({
  con <- dbConnect(
    RSQLite::SQLite(),
    dbname = "nycflights"
  )

  testthat::test_that("We get one airline", {
    one_airline <- dbGetQuery(
      con,
      "SELECT carrier, name FROM airlines LIMIT 1"
    )
    testthat::expect_is(one_airline, "data.frame")
    testthat::expect_equal(nrow(one_airline), 1)
    testthat::expect_equal(one_airline$carrier, "9E")
    testthat::expect_equal(one_airline$name, "Endeavor Air Inc.")
  })

  dbDisconnect(con)
})

# using `start_mock_db()` and `stop_mock_db()`
start_mock_db()
  con <- dbConnect(
    RSQLite::SQLite(),
    dbname = "nycflights"
  )

testthat::test_that("We get one airline", {
  one_airline <- dbGetQuery(
    con,
    "SELECT carrier, name FROM airlines LIMIT 1"
  )
  testthat::expect_is(one_airline, "data.frame")
  testthat::expect_equal(nrow(one_airline), 1)
  testthat::expect_equal(one_airline$carrier, "9E")
  testthat::expect_equal(one_airline$name, "Endeavor Air Inc.")
})

dbDisconnect(con)
stop_mock_db()
}
