% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneralisedPareto.R
\name{GP}
\alias{GP}
\title{Create a Generalised Pareto (GP) distribution}
\usage{
GP(mu = 0, sigma = 1, xi = 0)
}
\arguments{
\item{mu}{The location parameter, written \eqn{\mu} in textbooks.
\code{mu} can be any real number.  Defaults to \code{0}.}

\item{sigma}{The scale parameter, written \eqn{\sigma} in textbooks.
\code{sigma} can be any positive number.  Defaults to \code{1}.}

\item{xi}{The shape parameter, written \eqn{\xi} in textbooks.
\code{xi} can be any real number.  Defaults to \code{0}, which corresponds to a
Gumbel distribution.}
}
\value{
A \code{GP} object.
}
\description{
The GP distribution has a link to the \verb{\link{GEV}} distribution.
Suppose that the maximum of \eqn{n} i.i.d. random variables has
approximately a GEV distribution. For a sufficiently large threshold
\eqn{u}, the conditional distribution of the amount (the threshold
excess) by which a variable exceeds \eqn{u} given that it exceeds \eqn{u}
has approximately a GP distribution.  Therefore, the GP distribution is
often used to model the threshold excesses of a high threshold \eqn{u}.
The requirement that the variables are independent can be relaxed
substantially, but then exceedances of \eqn{u} may cluster.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail and much greater clarity.

In the following, let \eqn{X} be a GP random variable with location
parameter  \code{mu} = \eqn{\mu}, scale parameter \code{sigma} = \eqn{\sigma} and
shape parameter \code{xi} = \eqn{\xi}.

\strong{Support}:
\eqn{[\mu, \mu - \sigma / \xi]} for \eqn{\xi < 0};
\eqn{[\mu, \infty)} for \eqn{\xi \geq 0}{\xi >= 0}.

\strong{Mean}: \eqn{\mu + \sigma/(1 - \xi)} for
\eqn{\xi < 1}; undefined otherwise.

\strong{Median}: \eqn{\mu + \sigma[2 ^ \xi - 1]/\xi}{%
  \mu + \sigma[2^\xi - 1] / \xi} for \eqn{\xi \neq 0}{\xi != 0};
\eqn{\mu + \sigma\ln 2}{\mu + \sigma ln2} for \eqn{\xi = 0}.

\strong{Variance}:
\eqn{\sigma^2 / (1 - \xi)^2 (1 - 2\xi)}
for \eqn{\xi < 1 / 2}; undefined otherwise.

\strong{Probability density function (p.d.f)}:

If \eqn{\xi \neq 0}{\xi is not equal to 0} then
\deqn{f(x) = \sigma^{-1} [1 + \xi (x - \mu) / \sigma] ^ {-(1 + 1/\xi)}}{%
       f(x) = (1 / \sigma) [1 + \xi (x - \mu) / \sigma] ^ {-(1 + 1/\xi)}}
for \eqn{1 + \xi (x - \mu) / \sigma > 0}.  The p.d.f. is 0 outside the
support.

In the \eqn{\xi = 0} special case
\deqn{f(x) = \sigma ^ {-1} \exp[-(x - \mu) / \sigma]}{%
       f(x) = (1 / \sigma) exp[-(x - \mu) / \sigma]}
for \eqn{x} in [\eqn{\mu, \infty}).  The p.d.f. is 0 outside the support.

\strong{Cumulative distribution function (c.d.f)}:

If \eqn{\xi \neq 0}{\xi is not equal to 0} then
\deqn{F(x) = 1 - \exp\{-[1 + \xi (x - \mu) / \sigma] ^ {-1/\xi} \}}{%
       F(x) = 1 - exp{ -[1 + \xi (x - \mu) / \sigma] ^ (-1/\xi)} }
for \eqn{1 + \xi (x - \mu) / \sigma > 0}.  The c.d.f. is 0 below the
support and 1 above the support.

In the \eqn{\xi = 0} special case
\deqn{F(x) = 1 - \exp[-(x - \mu) / \sigma] \}}{%
        F(x) = 1 - exp[-(x - \mu) / \sigma] }
for \eqn{x} in \eqn{R}, the set of all real numbers.
}
\examples{

set.seed(27)

X <- GP(0, 2, 0.1)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
\seealso{
Other continuous distributions: 
\code{\link{Beta}()},
\code{\link{Cauchy}()},
\code{\link{ChiSquare}()},
\code{\link{Erlang}()},
\code{\link{Exponential}()},
\code{\link{FisherF}()},
\code{\link{Frechet}()},
\code{\link{GEV}()},
\code{\link{Gamma}()},
\code{\link{Gumbel}()},
\code{\link{LogNormal}()},
\code{\link{Logistic}()},
\code{\link{Normal}()},
\code{\link{RevWeibull}()},
\code{\link{StudentsT}()},
\code{\link{Tukey}()},
\code{\link{Uniform}()},
\code{\link{Weibull}()}
}
\concept{continuous distributions}
