% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{Weibull}
\alias{Weibull}
\title{Create a Weibull distribution}
\usage{
Weibull(shape, scale)
}
\arguments{
\item{shape}{The shape parameter \eqn{k}. Can be any positive real number.}

\item{scale}{The scale parameter \eqn{\lambda}. Can be any positive real
number.}
}
\value{
A \code{Weibull} object.
}
\description{
Generalization of the gamma distribution. Often used in survival and
time-to-event analyses.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3}, where the math
will render with additional detail and much greater clarity.

In the following, let \eqn{X} be a Weibull random variable with
success probability \code{p} = \eqn{p}.

\strong{Support}: \eqn{R^+} and zero.

\strong{Mean}: \eqn{\lambda \Gamma(1+1/k)}, where \eqn{\Gamma} is
the gamma function.

\strong{Variance}: \eqn{\lambda [ \Gamma (1 + \frac{2}{k} ) - (\Gamma(1+ \frac{1}{k}))^2 ]}

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{k}{\lambda}(\frac{x}{\lambda})^{k-1}e^{-(x/\lambda)^k}, x \ge 0
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{F(x) = 1 - e^{-(x/\lambda)^k}, x \ge 0}

\strong{Moment generating function (m.g.f)}:

\deqn{\sum_{n=0}^\infty \frac{t^n\lambda^n}{n!} \Gamma(1+n/k), k \ge 1}
}
\examples{

set.seed(27)

X <- Weibull(0.3, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other continuous distributions: \code{\link{Beta}},
  \code{\link{Cauchy}}, \code{\link{ChiSquare}},
  \code{\link{Exponential}}, \code{\link{FisherF}},
  \code{\link{Gamma}}, \code{\link{LogNormal}},
  \code{\link{Logistic}}, \code{\link{Normal}},
  \code{\link{StudentsT}}, \code{\link{Tukey}},
  \code{\link{Uniform}}
}
\concept{continuous distributions}
