% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NegativeBinomial.R
\name{cdf.NegativeBinomial}
\alias{cdf.NegativeBinomial}
\title{Evaluate the cumulative distribution function of a negative binomial distribution}
\usage{
\method{cdf}{NegativeBinomial}(d, x, ...)
}
\arguments{
\item{d}{A \code{NegativeBinomial} object created by a call to
\code{\link[=NegativeBinomial]{NegativeBinomial()}}.}

\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Evaluate the cumulative distribution function of a negative binomial distribution
}
\examples{

set.seed(27)

X <- NegativeBinomial(10, 0.3)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other NegativeBinomial distribution: \code{\link{pdf.NegativeBinomial}},
  \code{\link{quantile.NegativeBinomial}},
  \code{\link{random.NegativeBinomial}}
}
\concept{NegativeBinomial distribution}
