% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{ses}
\alias{ses}
\title{Shortest Edit Script}
\usage{
ses(a, b, max.diffs = gdo("max.diffs"), warn = gdo("warn"))
}
\arguments{
\item{a}{character}

\item{b}{character}

\item{max.diffs}{integer(1L), number of \emph{differences} after which we
abandon the \code{O(n^2)} diff algorithm in favor of a linear one.  Set to
\code{-1L} to always stick to the original algorithm (defaults to 10000L).}

\item{warn}{TRUE (default) or FALSE whether to warn if we hit `max.diffs`.}
}
\value{
character
}
\description{
Computes shortest edit script to convert \code{a} into \code{b} by removing
elements from \code{a} and adding elements from \code{b}.  Intended primarily
for debugging or for other applications that understand that particular
format.  See \href{GNU diff docs}{http://www.gnu.org/software/diffutils/manual/diffutils.html#Detailed-Normal}
for how to interpret the symbols.
}
\details{
\code{ses} will be much faster than any of the
\code{\link[=diffPrint]{diff*}} methods, particularly for large inputs with
limited numbers of differences.

NAs are treated as the string \dQuote{NA}.  Non-character inputs are coerced
to character.
}
\examples{
ses(letters[1:3], letters[2:4])
}
