% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difNLR.R
\name{difNLR}
\alias{difNLR}
\alias{fitted.difNLR}
\alias{plot.difNLR}
\alias{predict.difNLR}
\alias{print.difNLR}
\title{Performs DIF detection using Non-Linear Regression method.}
\usage{
difNLR(data, group,  type = "both", p.adjust.method = "BH",
  start, test = "F", alpha = 0.05)

\method{print}{difNLR}(x, ...)

\method{plot}{difNLR}(x, plot.type = "cc", item = "all",
  col = c("dodgerblue2", "goldenrod2"), shape = 21, size = 0.8,
  linetype = c(2, 1), title, ...)

\method{fitted}{difNLR}(object, item = "all", ...)

\method{predict}{difNLR}(object, item = "all", score, group, ...)
}
\arguments{
\item{data}{numeric: binary data matrix. See \strong{Details}.}

\item{group}{numeric: binary vector of group membership. "0" for reference group, "1" for focal group.}

\item{type}{character: type of DIF to be tested (either "both" (default), "udif", or "nudif"). See \strong{Details}.}

\item{p.adjust.method}{character: method for multiple comparison correction. See \strong{Details}.}

\item{start}{numeric: matrix with n rows (where n is the number of items) and at most 5 columns containing initial item parameters estimates. See \strong{Details}.}

\item{test}{character: test to be performed for DIF detection (either "F" (default), or "LR"). See \strong{Details}.}

\item{alpha}{numeric: significance level (default is 0.05).}

\item{x}{an object of 'difNLR' class}

\item{...}{other generic parameters for \code{plot}, \code{fitted} or \code{predict} functions.}

\item{plot.type}{character: type of plot to be plotted (either "cc" for characteristic curve (default), or "stat" for test statistics). See \strong{Details}.}

\item{item}{either character ("all"), or numeric vector, or single number corresponding to column indicators. See \strong{Details}.}

\item{col}{character: single value, or vector of two values representing colors for plot.}

\item{shape}{integer: shape parameter for plot.}

\item{size}{numeric: single number, or vector of two numbers representing line width in plot.}

\item{linetype}{numeric: single number, or vector of two numbers representing line type in plot for reference and focal group.}

\item{title}{string: title of plot.}

\item{object}{an object of 'difNLR' class}

\item{score}{numeric: standardized total score of subject.}
}
\value{
A list of class 'difNLR' with the following arguments:
\describe{
  \item{\code{DIF}}{either the column indicators of the items which were detected as DIF, or \code{"NONE"}.}
  \item{\code{test}}{the test used for DIF detection.}
  \item{\code{Sval}}{the values of \code{test} statistics.}
  \item{\code{pval}}{the p-values by \code{test}.}
  \item{\code{df}}{the degress of freedom of \code{test}.}
  \item{\code{coef}}{the matrix of estimated item parameters.}
  \item{\code{vcov}}{the list of estimated covariance matrices of item parameters.}
  \item{\code{group}}{the vector of group membership.}
  \item{\code{data}}{the binary data matrix.}
  \item{\code{type}}{character: type of DIF that was tested.}
  \item{\code{alpha}}{numeric: significance level.}
  \item{\code{conv.fail}}{numeric: number of convergence issues.}
  \item{\code{conv.fail.which}}{the indicators of the items which did not converge.}
  \item{\code{p.adjust.method}}{character: method for multiple comparison correction which was applied.}
}
}
\description{
Performs DIF detection procedure based on Non-Linear Regression and either F-test or likelihood ratio test of submodel.
}
\details{
DIF detection procedure based on Non-Linear Regression is the extension of Logistic Regression procedure (Swaminathan and Rogers, 1990).

The \code{data} is a matrix whose rows represents examinee answers ("1" correct, "0" incorrect) and columns correspond to the items. The \code{group} must be a vector of the same length as \code{nrow(data)}.

The \code{type} corresponds to type of DIF to be tested. Possible values are \code{"both"} to detect any DIF (uniform and/or non-uniform), \code{"udif"} to detect only uniform DIF or \code{"nudif"} to detect only non-uniform DIF.

The \code{start} is a matrix with a number of rows equal to number of items. The number of columns correspond to number of parameters in model in alternative hypothesis (5 for values \code{"both"} and \code{"nudif"} in type, 4 for \code{"udif"} in type). If start missing, initial values are calculated by \code{startNLR} function.

The \code{p.adjust.method} is a character for \code{p.adjust} function from the \code{stats} package. Possible values are \code{"holm"}, \code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.

The output of the difNLR is displayed by the \code{print.difNLR} function.

Two types of plots are available. The first one is obtained by setting \code{plot.type = "cc"} (default). The characteristic curve for item specified in item option is plotted. For default option \code{"all"} of item, characteristic curves of all converged items are plotted. The drawn curves represent best model.
The second plot is obtained by setting \code{plot.type = "stat"}. The  test statistics (either F-test, or LR-test, depends on argument \code{test}) are displayed on the Y axis, for each coverged item. The detection threshold is displayed by a horizontal line and items detected as DIF are printed with the red color. Only parameters \code{size} and \code{title} are used.

Fitted values are extracted by the \code{fitted.difNLR} function for item(s) specified in \code{item} argument.

Predicted values are produced by the \code{predict.difNLR} function for item(s) specified in \code{item} argument. \code{score} represents standardized total score of new subject and \code{group} argument represents group membership of new subject.

Missing values are allowed but discarded for item estimation. They must be coded as \code{NA} for both, \code{data} and \code{group} parameters.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMAT)

data  <- GMAT[, colnames(GMAT) != "group"]
group <- GMAT[, "group"]
# Testing both DIF effects using F test and Benjamini-Hochberg correction (default)
x <- difNLR(data, group)

# Testing both DIF effects using likelihood-ratio test
x <- difNLR(data, group, test = "LR")

# Testing both DIF effects with none multiple comparison correction
difNLR(data, group, type = "both", p.adjust.method = "none")

# Testing uniform DIF effects
difNLR(data, group, type = "udif")
# Testing non-uniform DIF effects
difNLR(data, group, type = "nudif")

# Graphical devices
plot(x)
plot(x, item = x$DIF)
plot(x, plot.type = "stat")

# Fitted values
fitted(x)
fitted(x, item = 1)
# Predicted values
predict(x)
predict(x, item = 1)

# Predicted values for new subjects
predict(x, item = 1, score = 0, group = 1)
predict(x, item = 1, score = 0, group = 0)
}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
\references{
Drabinova, A. and Martinkova P. (2016). Detection of Differenctial Item Functioning Based on Non-Linear Regression, Technical Report, V-1229, \url{http://hdl.handle.net/11104/0259498}.

Swaminathan, H. and Rogers, H. J. (1990). Detecting Differential Item Functioning Using Logistic Regression Procedures. Journal of Educational Measurement, 27, 361-370.
}
\seealso{
\code{\link[stats]{p.adjust}}
}
\keyword{DIF}

