% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{design_info}
\alias{design_info}
\title{Information about the design}
\usage{
design_info(dataSrc, predicate = NULL)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame with columns: person_id, item_id, item_score}

\item{predicate}{An optional expression to subset data, if NULL all data is used}
}
\value{
a list with the following components
\describe{
\item{design}{a data.frame with columns booklet_id, item_id, item_position, n_persons} 
\item{connected_booklets}{a data.frame with columns booklet_id, group; 
booklets with the same `group` are connected to eachother.} 
\item{connected}{TRUE/FALSE indicating whether the design is connected or not} 
\item{testlets}{a data.frame with columns item_id and testlet; items within the same testlet 
always occur together in a booklet} 
\item{adj_matrix}{list of two adjacency matrices: *weighted_by_items* and *weighted_by_persons*; These matrices can be 
useful in visually inspecting the design using a package like *igraph*}
}
}
\description{
This function is useful to inspect incomplete designs
}
