% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_column-layer.R
\name{add_column_layer}
\alias{add_column_layer}
\title{Add a column layer to the deckgl widget}
\usage{
add_column_layer(deckgl, id = "column-layer", data = NULL,
  properties = list(), ...)
}
\arguments{
\item{deckgl}{deckgl widget}

\item{id}{id of the layer}

\item{data}{url to fetch data from or data object}

\item{properties}{named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class, additionally there is a \code{getTooltip} property (callback)
showing a tooltip when the mouse enters an object,
e. g. \code{getTooltip = JS("object => object.name")}}

\item{...}{more properties (will be added to the properties object), useful if you
want to use a properties object for more than one layer}
}
\description{
The \code{ColumnLayer} can be used to render a heatmap of vertical cylinders.
It renders a tesselated regular polygon centered at each given position (a "disk"), and extrude it in 3d.
}
\examples{
## @knitr column-layer
hexagon_centroids <- system.file("sample-data/centroids.csv", package = "deckgl") \%>\%
  read.csv()

deck <- deckgl(zoom = 11, pitch = 35) \%>\%
  add_column_layer(
    data = hexagon_centroids,
    diskResolution = 12,
    getPosition = ~lng + lat,
    getElevation = ~value,
    getFillColor = JS("d => [48, 128, d.value * 255, 255]"),
    elevationScale = 5000,
    radius = 250,
    extruded = TRUE,
    getTooltip = JS("object => `height: ${object.value * 5000}m`")
  ) \%>\%
  add_mapbox_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/column-layer}
}
