% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_load.R
\name{load_plate}
\alias{load_plate}
\title{Load a previously saved ddPCR plate}
\usage{
load_plate(file)
}
\arguments{
\item{file}{Name of the file where the plate was saved.}
}
\value{
The plate that was saved in the given file.
}
\description{
Reloads a plate that has been saved with \code{\link[ddpcr]{save_plate}}.
}
\examples{
plate <- new_plate(sample_data_dir())
save_plate(plate, "myplate")
plate2 <- load_plate("myplate")
plate3 <- load_plate("myplate.rds")
identical(plate, plate2)
identical(plate, plate3)
unlink("myplate.rds")
}
\seealso{
\code{\link[ddpcr]{save_plate}}
}

