% Generated by roxygen2 (4.0.1): do not edit by hand
\name{mcmc}
\alias{mcmc}
\title{Performs MCMC routine for DCM}
\usage{
mcmc(observations, nattributes, qmatrix, pmatrix, parameter.means,
  parameter.acov, nobservations, nreps, initial.class, nchains,
  threshold.labels, lambda.equations, is.pi.r, is.parameter.randomized,
  parameterization.method, percent.reps.to.discard)
}
\arguments{
\item{observations}{a data frame or matrix of dichotomous responses}

\item{nattributes}{numeric value of number of attributes}

\item{qmatrix}{a data frame or matrix of 1s and 0s indicating relation between items and attributes.
This matrix specifies which items are required for mastery of each attribute (i.e., latent variable).
A matrix must be a size of \code{nItems X nAttributes}}

\item{pmatrix}{a numeric nclasses by nattributes matrix of all possible attribute profiles}

\item{parameter.means}{a numerical vector of calibrated item and structural parameters}

\item{parameter.acov}{a numerical matrix of covariances of item and structural parameters}

\item{nobservations}{a numeric value indicating number of rows of the observation data frame or matrix}

\item{nreps}{The number of iterations in MCMC per chain}

\item{initial.class}{The initial value of attribute profile for each respondent}

\item{nchains}{The number of chains in MCMC}

\item{threshold.labels}{an nclasses by nitems character matrix with appropriate item threshold labels}

\item{lambda.equations}{lambda parameter equations}

\item{is.pi.r}{If \code{FALSE} (the default), parameter values are the type of \code{taus} and \code{nus} or
\code{lambdas} and \code{gammas} else they are the type \code{pis} and \code{rs} as used in NC-RUM parameterization}

\item{is.parameter.randomized}{if true parameter estimates are randomized using acov matrix}

\item{parameterization.method}{optional character string of parameterization method used to calibrate parameters}

\item{percent.reps.to.discard}{The percent of iterations to be discarded}
}
\value{
a list of class and parameter data frame containing all accepted iteraction of MCMC
}
\description{
Performs MCMC routine for DCM
}

