% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.listOfModels.R
\name{plot.listOfModels}
\alias{plot.listOfModels}
\title{Plot method for DataRobot S3 objects of class listOfModels}
\usage{
\method{plot}{listOfModels}(x, y, metric = NULL, pct = NULL,
  selectRecords = NULL, orderDecreasing = NULL, textSize = 0.8,
  textColor = "black", borderColor = "blue", xpos = NULL, ...)
}
\arguments{
\item{x}{S3 object of class listOfModels to be plotted.}

\item{y}{Not used; included for conformance with plot() generic
function parameter requirements.}

\item{metric}{Character string; defines the metric to be used in
constructing the barplot.  If NULL (the default), the validation
set value for the project fitting metric is used; otherwise, this
value must name one of the elements of the metrics list associated
with each model in x.}

\item{pct}{Integer; specifies a samplePct value used in selecting
models to include in the barplot summary.  If NULL (the default),
all project models are included.  Note, however, that this list of
models is intersected with the list of models defined by the
selectRecords parameter, so that only those models identified by
both selectRecords and pct appear in the plot.}

\item{selectRecords}{Integer vector; specifies the individual
elements of the list x to be included in the barplot summary.
If NULL (the default), all models are included.  Note, however,
that this list of models is intersected with the list of models
defined by the pct parameter, so that only those models identified
by both selectRecords and pct appear in the plot.}

\item{orderDecreasing}{Logical; if TRUE, the barplot is built from
the bottom up in decreasing order of the metric values; if FALSE,
the barplot is built in increasing order of metric values.
The default is NULL, which causes the plot to be generated in the
order in which the models appear in the list x.}

\item{textSize}{Numeric; multiplicative scaling factor for the
model name labels on the barplot.}

\item{textColor}{Character or character vector; if character,
this parameter specifies the text color used in labelling all
models in the barplot;  if a character vector, it specifies one
color for each model in the plot.}

\item{borderColor}{Character; specifies the border color for all
bars in the barplot, surrounding a transparent background.}

\item{xpos}{Numeric or numeric vector; defines the horizontal
position of the center of all text labels on the plot.
The default is NULL, which causes all text to be centered in
the plot; if xpos is a single number, all text labels are centered
at this position; if xpos is a vector, it specifies one center
position for each model in the plot.}

\item{\dots}{Additional named parameters to be passed to R's barplot
function used in generating the plot}
}
\value{
None.  This function is called for its side-effect of
generating a plot.
}
\description{
Method for R's generic plot function for DataRobot S3 objects
of class listOfModels.  This function generates a horizontal
barplot as described under Details.
}
\details{
This function generates a horizontal barplot with one bar for
each model characterized in the 'listOfModels' object x.
The length of each bar is specified by the value of metric;
if this parameter is specified as NULL (the default), the
project fitting metric is used, as determined by the projectMetric
value from the first element of x.  Text is added to each bar in
the plot, centered at the position specified by the xpos parameter,
based on the value of the modelType element of each model in the
list x.  The size and color of these text labels may be controlled
with the textSize and textColor parameters.  The order in which
these models appear on the plot is controlled by the choice of
metric and the value of the orderDecreasing parameter, and subsets
of the models appearing in the list x may be selected via the pct
and selectRecords parameters.
}
