/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDF;

public abstract class BaseGraphMaker
implements GraphMaker {
    private int counter = 0;
    protected ReificationStyle style;
    private Graph defaultGraph;

    public BaseGraphMaker(ReificationStyle style) {
        this.style = style;
    }

    public ReificationStyle getReificationStyle() {
        return this.style;
    }

    public Graph getGraph() {
        if (this.defaultGraph == null) {
            this.defaultGraph = this.createGraph();
        }
        return this.defaultGraph;
    }

    public Graph openGraph() {
        if (this.defaultGraph == null) {
            throw new DoesNotExistException("no default graph in this GraphMaker [" + this.getClass() + "]");
        }
        return this.defaultGraph;
    }

    public Graph createGraph() {
        return this.createGraph("anon_" + this.counter++ + "", false);
    }

    public Graph createGraph(String name) {
        return this.createGraph(name, false);
    }

    public Graph openGraph(String name) {
        return this.openGraph(name, false);
    }

    public Graph getDescription() {
        return this.getDescription(Node.createAnon());
    }

    public Graph getDescription(Node root) {
        Graph result = Factory.createGraphMem();
        this.addDescription(result, root);
        return result;
    }

    public Graph addDescription(Graph desc, Node self) {
        Node mode = JenaModelSpec.styleAsJMS(this.style);
        desc.add(Triple.create(self, JenaModelSpec.reificationMode.asNode(), mode));
        desc.add(Triple.create(self, RDF.Nodes.type, this.getMakerClass()));
        this.augmentDescription(desc, self);
        return desc;
    }

    protected abstract void augmentDescription(Graph var1, Node var2);

    public abstract Node getMakerClass();
}

