% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{chickgr2}
\alias{chickgr2}
\title{Serie de tiempo para el peso de pollos.}
\format{
Contiene cuatro variables, como sigue:
\describe{
\item{dieta}{Un factor de 4 niveles que indica cual dieta recibio el pollo.}
\item{pollo}{Un codigo numerico unico asignado a cada pollo. El numero se asigno
      de acuerdo a la dieta.}
  \item{tiempo}{El numero de dias desde el nacimiento hasta la medicion.}
  \item{peso}{Peso del cuerpo del pollo, en gr.}
 }
}
\source{
Los datos fueron obtenidos desde la libreria 'alr4'.
}
\usage{
data(chickgr2)
}
\description{
Datos de series de tiempo. El peso de los pollos fue medido al momento del nacimiento y cada dos dias despues
hasta el dia 20. Ellos tambien fueron medidos el dia 21. Hay cuatro grupos
de dietas de proteinas.
}
\examples{
data(chickgr2)    
head(chickgr2)
library(lattice)
xyplot(peso~tiempo|as.factor(dieta), groups=as.factor(pollo), type="b",data=chickgr2) 
}
\references{
Crowder M, Hand D. 1990. Analysis of Repeated Measures. Chapman and Hall
}
\keyword{datasets}
