% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{dgorange2}
\alias{dgorange2}
\title{Crecimiento diametral de árboles de naranjo}
\format{
Series de tiempo de diámetro, que contienen las siguientes columnas:
\describe{
\item{arbol}{Identificador del árbol.}
\item{tiempo}{Número de dias desde el 31 de diciembre de 1968.}
\item{peri}{El perimetro del tronco (mm), medido a la altura del pecho.}
\item{dap}{Diámetro a la altura del pecho (mm).}
\item{sitio}{un factor, representando condiciones de sitio, en dos niveles. Esta columna es ficticia.}
\item{especie}{un factor, representando especie del árbol, en tres niveles.  Esta columna es ficticia.}
 }
}
\source{
Los numeros de estos datos provienen de la dataframe 'Orange' de la libreria 'datasets', pero las 
 columnas fueron creadas solo para fines academicos.
}
\usage{
data(dgorange2)
}
\description{
Mediciones de crecimiento diametral de árboles de Naranjo. Note que las columnas
 sitio y especie son ficticias y solo creadas por propositos academicos.
}
\examples{
data(dgorange2)

coplot(dap ~ tiempo | arbol, data = dgorange2, show.given = FALSE)
plot(dap ~ tiempo, data = dgorange2, subset = arbol== 3,
     xlab = "Tiempo (numero de dias desde 31/12/1968)",
     ylab = "Diametro (mm)", las = 1)
}
\keyword{datasets}
