% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{ptaeda}
\alias{ptaeda}
\title{Height growth of Pinus taeda (Loblolly pine) trees}
\format{
An object of class c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame") containing the following columns:
\describe{
\item{seed.id}{an ordered factor indicating the seed source for the tree. The ordering is according to increasing maximum height.}
\item{age}{a numeric vector of tree ages, in yr.}
\item{height}{a numeric vector of tree heights, in m.}
 }
}
\source{
Pinheiro, J. C. and Bates, D. M. (2000) Mixed-effects Models in S and S-PLUS. Springer.
}
\usage{
data(ptaeda)
}
\description{
The Loblolly data frame has 84 rows and tree columns of records of the tree height growth of Loblolly pine trees. This dataframe
 is a slight modification to the original dataframe "Loblolly" from the datasets R package.
}
\examples{

data(ptaeda)
plot(height ~ age, data = ptaeda, subset = seed.id == 329,
     xlab = "Tree age (yr)", las = 1,
     ylab = "Tree height (m)",
     main = "Loblolly data and fitted curve (seed.id 329 only)")
m1 <- nls(height ~ SSasymp(age, Asym, R0, lrc),
           data = ptaeda, subset = seed.id == 329)
age <- seq(0, 30, length.out = 101)
lines(age, predict(m1, list(age = age)))
}
\keyword{datasets}
