## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----setup--------------------------------------------------------------------
#  library(datamods)

## -----------------------------------------------------------------------------
#  # Using a supported language
#  set_i18n("fr")
#  
#  # Using a named list
#  set_i18n(list("Some label" = "Its translation", ...))
#  
#  # Using a data.framewith 2 columns
#  set_i18n(data.frame(label = c(...), translation = c(...)))
#  
#  # Using a CSV file
#  set_i18n("path/to/file.csv")

## -----------------------------------------------------------------------------
#  set_i18n("fr")

## -----------------------------------------------------------------------------
#  set_i18n("mk")

## -----------------------------------------------------------------------------
#  set_i18n("pt")

## -----------------------------------------------------------------------------
#  set_i18n("al")

## -----------------------------------------------------------------------------
#  set_i18n("cn")

## -----------------------------------------------------------------------------
#  set_i18n("es")

## -----------------------------------------------------------------------------
#  set_i18n("de")

## -----------------------------------------------------------------------------
#  set_i18n("tr")

## -----------------------------------------------------------------------------
#  set_i18n("kr")

## -----------------------------------------------------------------------------
#  set_i18n("pl")

## -----------------------------------------------------------------------------
#  set_i18n("ja")

## -----------------------------------------------------------------------------
#  options("datamods.i18n" = list(
#    "Import a dataset from an environment" = "Importer un jeu de données depuis l'environnement global",
#    "Select a data.frame:" = "Sélectionner un data.frame :",
#    ...
#  ))

## -----------------------------------------------------------------------------
#  set_i18n(data.frame(
#    label = c("Import a dataset from an environment", "Select a data.frame:", ...),
#    translation = c("Importer un jeu de données depuis l'environnement global", "Sélectionner un data.frame :", ...)
#  ))

## -----------------------------------------------------------------------------
#  set_i18n("path/to/file.csv")

## ----echo=FALSE, eval=TRUE, comment=""----------------------------------------
cat(readLines(system.file("i18n", "fr.csv", package = "datamods"), encoding = "UTF-8"), sep = '\n')

