% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{dcscatter}
\alias{dcscatter}
\title{dcscatter adds a scatter plot to the dashboard}
\usage{
dcscatter(x, y, title = paste(x, " * ", y), spansize = 4,
  width = dashboard.env$outerwidth * spansize/12, height = 250,
  symbolesize = 2, symboletype = "circle", clipaddingsize = 10,
  hlightedsize = 4)
}
\arguments{
\item{x}{column name of a single numeric in data frame \code{data} for drawing a scatter plot}

\item{y}{column name of a single numeric in data frame \code{data} for drawing a scatter plot}

\item{title}{character for the title of the generated scatter plot}

\item{spansize}{integer between 1 to 12 for the width of the element in the web page}

\item{width}{integer for the width (in pixels) of the element in the web page}

\item{height}{integer for the height (in pixels) of the element in the web page}

\item{symbolesize}{integer for adjusting the symbole size}

\item{symboletype}{character for defining the symbole type}

\item{clipaddingsize}{integer for adjusting the clipadding size}

\item{hlightedsize}{integer for adjusting the highlighted size}
}
\description{
\code{dcscatter} generates a scatter plot
}
\examples{
dashboard_open(data=iris) # other options: pathoutput=getwd() ...
dcpiechart(x=names(iris)[5])
dcscatter(x=names(iris)[1], y=names(iris)[3] )
dcbarchart(x=names(iris)[1] , gap=75)
dcpiechart(x=names(iris)[2])
dctable(index=names(iris)[5])
dashboard_launch(browse = FALSE) # Just generates files and server is not launched
}

