% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.collapse.recursive.r
\name{gl.collapse.recursive}
\alias{gl.collapse.recursive}
\title{Recursively collapse a distance matrix by amalgamating populations}
\usage{
gl.collapse.recursive(x, tloc = 0, tpop = 1, verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object from which the distance matricies are to be calculated [required]}

\item{tloc}{-- threshold defining a fixed difference (e.g. 0.05 implies 95:5 vs 5:95 is fixed) [default 0]}

\item{tpop}{-- max number of fixed differences allowed in amalgamating populations [default 0]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
A list containing the final gl object and the following square matricies
        [[1]] $gl -- the input genlight object;
        [[2]] $fd -- raw fixed differences;
        [[3]] $pcfd -- percent fixed differences;
        [[4]] $nobs -- mean no. of individuals used in each comparison;
        [[5]] $nloc -- total number of loci used in each comparison;
        [[6]] $expfpos -- NA's, populated if required by gl.fixed.diff setting test=T [by simulation];
        [[7]] $sdfpos -- NA's, populated if required by gl.fixed.diff setting test=T [by simulation];
        [[8]] $prob -- NA's, populated by gl.fixed.diff setting test=T [by simulation]
}
\description{
This script generates a fixed difference matrix from a genlight object \{adegenet\} and 
amalgamates populations with a fixed difference count less than or equal to a specified 
threshold, tpop. The parameter tpop is used to generate amalgamations based on absolute absence
of fixed differences (tpop=0), corroborated fixed differences (tpop=1, recommended), or a 
higher level of corroboration after examining the distribution of fixed differences across 
the dataset.
}
\details{
The distance matricies are generated by gl.fixed.diff(). The script gl.collapse() examines
the distance matrix of fixed differences and amalgamates populations with fixed differences
of zero. This is done iteratively until no further amalgamations are possible. If
tpop is greater than zero, the script then steps up to tpop=1, that is, examines
the distance matrix of fixed differences and amalgamates populations with fixed differences
of one or less until no further amalgamations are possible. And so on, until the user specified
value of tpop is reached.

A final table is generated with no fixed differences less than or equal to the specified 
threshold, tpop, and the genlight object is recoded with the new population assignments 
arising from the amalgamations.
}
\examples{
fd <- gl.collapse.recursive(testset.gl, tloc=0, tpop=2, verbose=3)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
