% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.compliance.check.r
\name{gl.compliance.check}
\alias{gl.compliance.check}
\title{Checks a gl object to see if it complies with dartR expectations, and amends to comply if necessary}
\usage{
gl.compliance.check(x, verbose = NULL)
}
\arguments{
\item{x}{-- name of the input genlight object [required]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
A genlight object that conforms to the expectations of dartR
}
\description{
A genlight object used by dartR has a number of requirements that allow functions within the package to operate
correctly. The genlight object comprises
}
\details{
(a) The SNP genotypes or Tag Presence/Absence data (SilicoDArT);
(b) An associated dataframe (gl@other$loc.metrics) containing the locus metrics (e.g. Call Rate, Repeatability, etc);
(c) An associated dataframe (gl@other$ind.metrics) containing the individual/sample metrics (e.g. sex, latitude, longitude, etc);
(d) A specimen identity field (indNames(gl)) with the unique labels applied to each individual/sample;
(e) A population assignment (popNames) for each individual/specimen;
(f) Flags that indicate whether or not calculable locus metrics have been updated.

This function will check to see that the genlight object conforms to expectation in regard to the above requirements,
and if it does not, will rectify it.
}
\examples{
x <- gl.compliance.check(testset.gl)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
