% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.edit.recode.ind.r
\name{gl.edit.recode.ind}
\alias{gl.edit.recode.ind}
\title{Create or edit a individual (=specimen) names and create an recode_ind file}
\usage{
gl.edit.recode.ind(gl, ind.recode = NULL)
}
\arguments{
\item{gl}{Name of the genlight object for which individuals are to be relabelled.[required]}

\item{ind.recode}{Name of the file to output the new assignments [optional]}
}
\value{
An object of class ("genlight") with the revised individual labels
}
\description{
A script to edit individual names in a genlight object, or to 
create a reassignment table taking the individual labels
from a genlight object, or to edit existing individual labels in
an existing recode_ind file.
}
\details{
Renaming individuals may be required when there have been errors in labelling arising
in the process from sample to DArT files. There may be occasions where renaming
individuals is required for preparation of figures. Caution needs to be exercised
because of the potential for breaking the "chain of evidence" between the samples themselves
and the analyses. REcoding individuals can be done with a recode table (csv).

This script will input an existing recode table for editting and
optionally save it as a new table, or if the name of an input table is not
supplied, will generate a table using the individual labels in the 
parent genlight object.

The script, having deleted individuals, identifies resultant monomorphic loci or loci
with all values missing and deletes them (using gl.filter.monomorphs.r)

The script returns a genlight object with the new individual labels.
}
\examples{
\dontrun{
gl <- gl.edit.recode.ind(gl)
gl <- gl.edit.recode.ind(gl, pop.recode="ind.recode.table.csv")
gl <- gl.edit.recode.ind(gl, pop.recode="ind.recode.table.csv", 
}
#Ammended Georges 9-Mar-17
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}

