% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/send_to_dai.R
\name{dai_notify}
\alias{dai_notify}
\title{Notify on job completion}
\usage{
dai_notify(response, loc = "eu", token = dai_token(), sound = 2)
}
\arguments{
\item{response}{a HTTP response object generated by \code{dai_async()}}

\item{loc}{A two-letter region code; "eu" or "us"}

\item{token}{An authentication token generated by \code{dai_auth()} or
another auth function}

\item{sound}{A number from 1 to 10 for the Beepr sound selection
(https://www.r-project.org/nosvn/pandoc/beepr.html).}
}
\value{
no return value, called for side effects
}
\description{
Queries to the Google Cloud Services (GCS) Document AI API
about the status of a previously submitted asynchronous job
and emits a sound notification when the job is complete.
}
\examples{
\dontrun{
response <- dai_async(myfiles)
dai_notify(response)
}
}
