% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_transfer.R
\name{set_transfer}
\alias{set_transfer}
\alias{set_transfer,ANY-method}
\alias{set_transfer,Transferable-method}
\title{Set transfer events}
\usage{
set_transfer(x, interval, times, biomass, scaled_comp)

\S4method{set_transfer}{ANY}(x, interval, times, biomass, scaled_comp)

\S4method{set_transfer}{Transferable}(x, interval, times, biomass, scaled_comp)
}
\arguments{
\item{x}{vector of \code{EffectScenario} objects}

\item{interval}{optional \code{numeric}, interval in time units of the scenario,
set to \code{-1} to disable transfers.}

\item{times}{optional \code{numeric} vector of time points where transfers occur}

\item{biomass}{optional \code{numeric} vector, amount of biomass that is being
transferred at each transfer}

\item{scaled_comp}{optional \code{character} vector of affected compartments
that are scaled according to new biomass levels}
}
\value{
Modified \code{EffectScenario} objects
}
\description{
A \emph{transfer} refers to an event where a certain amount of biomass (\emph{BM})
is moved to a new medium after a period of time. This feature replicates
a procedure occurring e.g. in Lemna effect studies and may be necessary to recreate
study results.
}
\details{
Any transfer time point must also be an output time point. If a transfer
occurs, simulation results of that time point will report the model state
\strong{before} the transfer. Be aware that in order to use transfers at regular
intervals, the simulation must start at time point zero.
\subsection{Transferred biomass}{

At each transfer, a defined amount of biomass is transferred to a new medium.
This is modeled by interrupting the simulation at a transfer time point, modifying
the biomass level \code{BM}, and scaling affected compartments according to new
biomass levels. Scaling of compartments depending on biomass, such as
\emph{internal toxicant mass}, is necessary to correctly reflect mass balances and
concentrations over time.

Transferred biomass is set using the \code{biomass} parameter. Is is either a
single numerical value in which case the same biomass level is set at each
transfer. Or it is a vector of numerical values with the same length as the
\code{times} parameter in which case a custom biomass level can be set for each
transfer. Multiple biomass levels can only be set in conjunction with
custom transfer time points.

Some scenario types define default values for transferred biomass based
on common study set ups.
}

\subsection{Regular and custom transfer time points}{

Transfers can occur either in regular intervals of time or at selected, custom
time points. For regular intervals, the parameter \code{interval} is set to a single
numeric value which has the same unit as the scenario's time dimension. As an
example: if a scenario uses the unit of \emph{days} for time, the transfer interval
is also specified in \emph{days}:

Transfers occurring at custom time points are set by passing a numerical vector
to the parameter \code{times}. The time points' units must match with the unit of
time in the scenario. A custom transfer time point \strong{must not occur at the
starting time point of a simulation}.
}

\subsection{Affected compartments}{

Some compartments depend on biomass to correctly reflect mass balances and
concentrations over time, such as \emph{internal toxicant mass}. These compartments
need to be scaled linearly to reflect the change in biomass levels.
The parameter \code{scaled_comp} accepts a character vector of compartment names
which are scaled at each transfer. This parameter should only be used with
custom, user-defined models. If no compartment needs to be scaled, set or
use the default value of \code{character(0)}.
}
}
\examples{
# Simulate biomass transfer of 50 *g dw/m²* at a regular interval of 7 *days*
metsulfuron \%>\%
  set_transfer(interval=7, biomass=50) \%>\%
  simulate()

# Simulate irregular biomass transfers occuring at days 5, 10, and 12
metsulfuron \%>\%
  set_transfer(times=c(5,10,12), biomass=50) \%>\%
  simulate()

# Simulate irregular transfers with changing amounts of transferred biomass
metsulfuron \%>\%
  set_transfer(times=c(5,10,12), biomass=c(50,20,10)) \%>\%
  simulate()
}
\seealso{
\code{\link[=Lemna_Schmitt]{Lemna_Schmitt()}}
}
