% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.r
\name{plot_ppc}
\alias{plot_ppc}
\title{Creates a PPC plot for a single dataset}
\usage{
plot_ppc(
  rs_mean,
  rs_range,
  obs_mean = NULL,
  obs_full = NULL,
  xy_lim = NULL,
  study = NULL,
  outfile = NULL,
  ...
)
}
\arguments{
\item{rs_mean}{\code{data.frame}, model results best fit params}

\item{rs_range}{\code{data.frame}, predictions (min, max from param.sample run)}

\item{obs_mean}{\code{data.frame}, observations with means per treatment level}

\item{obs_full}{\code{data.frame}, full data set including results for replicates}

\item{xy_lim}{optional \code{numeric}, limits of x and y axis for plotting}

\item{study}{optional \code{string}, name of study which can be used as key}

\item{outfile}{optional \code{string}, file path is given = save graph}

\item{...}{any additional parameters}
}
\value{
\code{data.frame} with fitted and observed frond numbers
}
\description{
A sample of parameters representing the uncertainty within the dataset
is passed to the function. All parameter combinations and exposure patterns
are simulated and the range of predicted frond numbers is derived for a
single study. The uncertainty is displayed by a Posterior Predicitve Plot
(PPC).
}
