% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum.R, R/package.R
\docType{package}
\name{cusum}
\alias{cusum}
\alias{cusum-package}
\title{Non-risk-adjusted CUSUM Charts}
\usage{
cusum(failure_probability, patient_outcomes, limit, weights = NA,
  odds_multiplier = 2, reset = TRUE)
}
\arguments{
\item{failure_probability}{Double. Baseline failure probability}

\item{patient_outcomes}{Integer. Vector of binary patient outcomes (0,1)}

\item{limit}{Double. Control limit for signalling performance change}

\item{weights}{Double. Optional vector of weights, if empty, standard CUSUM weights are calculated with weights_t}

\item{odds_multiplier}{Double. Odds multiplier of adverse event under the alternative hypothesis (<1 looks for decreases)}

\item{reset}{Logical. Reset the CUSUM after a signal to 0; defaults to TRUE}
}
\description{
Calculate non-risk-adjusted CUSUM charts for performance data

Provides functions for constructing and evaluating CUSUM charts and RA-CUSUM charts with focus on false signal probability in health care processes.
}
\examples{

# control limit can be obtained with cusum_limit_sim(),
# here it is set to an arbitrary value (2.96)

# CUSUM of in-control process
# simulate patient outcomes
set.seed(2046)
patient_outcomes <- as.logical(rbinom(n = 100, size = 1, prob = 0.05))


cs_ic <- cusum(
  failure_probability = 0.05,
  patient_outcomes,
  limit = 2.96
)

# CUSUM of out-of-control process
# simulate patient outcome
set.seed(2046)
patient_outcomes <- as.logical(rbinom(n = 100, size = 1, prob = 0.2))

cs_oc <- cusum(
  failure_probability = 0.05,
  patient_outcomes,
  limit = 2.96
)
}
\author{
Lena Hubig
}
