% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_cai}
\alias{get_cai}
\title{Calculate CAI}
\usage{
get_cai(cf, rscu)
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by `count_codons()`.}

\item{rscu}{rscu table containing CAI weight for each codon. This table could be
generated with `est_rscu` or prepared manually.}
}
\value{
a named vector of CAI values
}
\description{
\code{get_cai} calculates Codon Adaptation Index (CAI) of each input CDS
}
\examples{
# estimate CAI of yeast genes based on RSCU of highly expressed genes
heg <- head(yeast_exp[order(-yeast_exp$fpkm), ], n = 500)
cf_all <- count_codons(yeast_cds)
cf_heg <- cf_all[heg$gene_id, ]
rscu_heg <- est_rscu(cf_heg)
cai <- get_cai(cf_all, rscu_heg)
head(cai)
hist(cai)

}
\references{
Sharp PM, Li WH. 1987. The codon Adaptation Index--a measure of directional
  synonymous codon usage bias, and its potential applications. Nucleic Acids Res 15:1281-1295.
}
