% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dfName2Value}
\alias{dfName2Value}
\title{Get value for variable of interest}
\usage{
dfName2Value(df, valuename = "", wherename = "", wherevalue = "")
}
\arguments{
\item{df}{A data frame (or tibble) with four columns (`_id`,
`identifier`, `name`, `value`) as returned by
\link{dfTrials2Long}}

\item{valuename}{A character string for the name of the field
that holds the value for the variable of interest
(e.g., a summary measure such as "endPoints.*tendencyValue.value")}

\item{wherename}{A character string to identify the variable
of interest (e.g., "endPoints.endPoint.title")}

\item{wherevalue}{A character string with the value of interest
for the variable of interest (e.g., "duration of response")}
}
\value{
A data frame (or tibble, if \code{dplyr} is loaded)
 with columns `_id`, `identifier`,
 `name`, `value` that only includes the values of interest,
 where values are strings unless all value elements
 are numbers. The `ìdentifier` is generated by function
 \link{dfTrials2Long} to identify matching elements, e.g.
 endpoint descriptions and measurements.
}
\description{
Get information of interest (e.g., endpoint)
from long data frame of protocol- or result-related
trial information as returned by \link{dfTrials2Long}.
Parameters `valuename`, `wherename` and `wherevalue` are matched
using Perl regular expressions and ignoring case.
}
\examples{
\dontrun{

dbc <- nodbi::src_sqlite(collection = "my_collection")

df <- dbGetFieldsIntoDf(
fields = c(
  # ctgov - typical results fields
  "clinical_results.baseline.analyzed_list.analyzed.count_list.count",
  "clinical_results.baseline.group_list.group",
  "clinical_results.baseline.analyzed_list.analyzed.units",
  "clinical_results.outcome_list.outcome",
  "study_design_info.allocation",
  # euctr - typical results fields
  "trialInformation.fullTitle",
  "subjectDisposition.recruitmentDetails",
  "baselineCharacteristics.baselineReportingGroups.baselineReportingGroup",
  "endPoints.endPoint",
  "trialChanges.hasGlobalInterruptions",
  "subjectAnalysisSets",
  "adverseEvents.seriousAdverseEvents.seriousAdverseEvent"
  ), con = dbc
)

# convert to long
reslong <- dfTrials2Long(df = df)

# get values for endpoint of interest, e.g. 'response'
dfName2Value(
  df = reslong,
  valuename = paste0(
    "endPoints.endPoint.*armReportingGroup.tendencyValues.tendencyValue.value|",
    "clinical_results.*category.measurement_list.measurement.value|",
    "clinical_results.*outcome.measure.units|endPoints.endPoint.unit"
  ),
  wherename = "clinical_results.*outcome.measure.title|endPoints.endPoint.title",
  wherevalue = "response"
)

}

}
