% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanbasis.R
\name{meanbasis}
\alias{meanbasis}
\title{Compute means of basis functions}
\usage{
meanbasis(basis)
}
\arguments{
\item{basis}{a basis object of class \code{"\link[fda]{basisfd}"}}
}
\value{
Vector of means of the basis functions
}
\description{
Given a basis object as defined in the \pkg{fda} package (see \code{\link[fda]{basisfd}}),
this function simply computes the vector of means of the basis functions. Used internally.
}
\examples{


require(fda)
fbasis11 <- create.fourier.basis(nbasis=11)
zapsmall(meanbasis(fbasis11))    # the sine functions have mean 0

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
}
