% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\name{body_add_table_list}
\alias{body_add_table_list}
\alias{body_add_flextable_list}
\alias{body_add_crosstable_list}
\title{Add a list of tables}
\usage{
body_add_table_list(
  doc,
  l,
  fun_before = "title2",
  fun_after = NULL,
  fun = fun_before,
  ...
)

body_add_flextable_list(...)

body_add_crosstable_list(...)
}
\arguments{
\item{doc}{a \code{rdocx} object, created by \code{\link[officer:read_docx]{officer::read_docx()}}}

\item{l}{a named list of tables (of class \code{crosstable}, \code{flextable}, or \code{data.frame}).}

\item{fun_before}{a function to be used before each table}

\item{fun_after}{a function to be used after each table.}

\item{fun}{Deprecated}

\item{...}{arguments passed on to \code{\link[=body_add_crosstable]{body_add_crosstable()}} or \code{\link[=body_add_flextable]{body_add_flextable()}}}
}
\value{
The docx object \code{doc}
}
\description{
Add a list of tables in an officer document. \code{crosstables} will be added using \code{\link[=body_add_crosstable]{body_add_crosstable()}} and \code{flextables} will be added using \code{\link[flextable:body_add_flextable]{flextable::body_add_flextable()}}. Plain dataframes will be converted to flextables.
}
\section{\code{fun_before} and \code{fun_after}}{

These should be function of the form \verb{function(doc, .name)} where \code{.name} is the name of the current table of the list.
You can also pass \code{"title2"} to add the name as a title of level 2 between each table (works for levels 3 and 4 as well), \code{"newline"} to simply add a new line, or even \code{NULL} to not separate them (beware that the tables might merge then).
\code{fun_before} is designed to add a title while \code{fun_after} is designed to add a table legend (cf. examples).
}

\examples{
library(officer)
ctl = list(iris2=crosstable(iris2, 1),
           "Just a flextable"=flextable::flextable(mtcars2[1:5,1:5]),
           "Just a dataframe"=iris2[1:5,1:5])

fun1 = function(doc, .name){
    doc \%>\%
        body_add_title(" This is table '{.name}' as a flex/crosstable", level=2) \%>\%
        body_add_normal("Here is the table:")
}
fun2 = function(doc, .name){
  doc \%>\% body_add_table_legend("{.name}", bookmark=.name)
}
read_docx() \%>\%
  body_add_title("Separated by subtitle", 1) \%>\%
  body_add_table_list(ctl, fun_before="title2") \%>\%
  body_add_break() \%>\%
  body_add_title("Separated using a custom function", 1) \%>\%
  body_add_normal("You can therefore use bookmarks, for instance here are
                   tables \\\\@ref(iris2), \\\\@ref(just_a_flextable)
                   and \\\\@ref(just_a_dataframe).") \%>\%
  body_add_table_list(ctl, fun_before=fun1, fun_after=fun2, body_fontsize=8) \%>\%
  write_and_open()
}
