% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-methods.R
\name{summary,PseudoDualSimulations-method}
\alias{summary,PseudoDualSimulations-method}
\title{Summary for Pseudo Dual responses simulations, relative to a given pseudo DLE and efficacy model 
(except the EffFlexi class model)}
\usage{
\S4method{summary}{PseudoDualSimulations}(
  object,
  trueDLE,
  trueEff,
  targetEndOfTrial = 0.3,
  targetDuringTrial = 0.35,
  ...
)
}
\arguments{
\item{object}{the \code{\linkS4class{PseudoDualSimulations}} object we want to summarize}

\item{trueDLE}{a function which takes as input a dose (vector) and returns the true probability (vector)
of DLE}

\item{trueEff}{a function which takes as input a dose (vector) and returns the mean efficacy value(s) (vector).}

\item{targetEndOfTrial}{the target probability of DLE that are used at the end of a trial. Default at 0.3.}

\item{targetDuringTrial}{the target probability of DLE that are used during the trial. Default at 0.35.}

\item{\dots}{Additional arguments can be supplied here for \code{trueDLE} and \code{trueEff}}
}
\value{
an object of class \code{\linkS4class{PseudoDualSimulationsSummary}}
}
\description{
Summary for Pseudo Dual responses simulations, relative to a given pseudo DLE and efficacy model 
(except the EffFlexi class model)
}
\examples{
##obtain the plot for the simulation results
##If DLE and efficacy responses are considered in the simulations
##Specified your simulations when no samples are used
data <- DataDual(doseGrid=seq(25,300,25))
##First for the DLE model 
##The DLE model must be of 'ModelTox' (e.g 'LogisticIndepBeta') class 
DLEmodel <- LogisticIndepBeta(binDLE=c(1.05,1.8),
                              DLEweights=c(3,3),
                              DLEdose=c(25,300),
                              data=data)

##The efficacy model of 'ModelEff' (e.g 'Effloglog') class 
Effmodel<-Effloglog(Eff=c(1.223,2.513),Effdose=c(25,300),
                    nu=c(a=1,b=0.025),data=data)

##The escalation rule using the 'NextBestMaxGain' class
mynextbest<-NextBestMaxGain(DLEDuringTrialtarget=0.35,
                            DLEEndOfTrialtarget=0.3)


##The increments (see Increments class examples) 
## 200\% allowable increase for dose below 300 and 200\% increase for dose above 300
myIncrements<-IncrementsRelative(intervals=c(25,300),
                                 increments=c(2,2))
##cohort size of 3
mySize<-CohortSizeConst(size=3)
##Stop only when 36 subjects are treated
myStopping <- StoppingMinPatients(nPatients=36)
##Now specified the design with all the above information and starting with a dose of 25

##Specified the design(for details please refer to the 'DualResponsesDesign' example)
design <- DualResponsesDesign(nextBest=mynextbest,
                              model=DLEmodel,
                              Effmodel=Effmodel,
                              stopping=myStopping,
                              increments=myIncrements,
                              cohortSize=mySize,
                              data=data,startingDose=25)
##Specify the true DLE and efficacy curves
myTruthDLE<- function(dose)
{ DLEmodel@prob(dose, phi1=-53.66584, phi2=10.50499)
}

myTruthEff<- function(dose)
{Effmodel@ExpEff(dose,theta1=-4.818429,theta2=3.653058)
}

## Then specified the simulations and generate the trial for 2 times
mySim <-simulate(object=design,
                 args=NULL,
                 trueDLE=myTruthDLE,
                 trueEff=myTruthEff,
                 trueNu=1/0.025,
                 nsim=2,
                 seed=819,
                 parallel=FALSE)

##Then produce a summary of your simulations
summary(mySim,
        trueDLE=myTruthDLE,
        trueEff=myTruthEff)
##If DLE and efficacy samples are involved
##Please refer to design-method 'simulate DualResponsesSamplesDesign' examples for details
##specified the next best
mynextbest<-NextBestMaxGainSamples(DLEDuringTrialtarget=0.35,
                                   DLEEndOfTrialtarget=0.3,
                                   TDderive=function(TDsamples){
                                     quantile(TDsamples,prob=0.3)},
                                   Gstarderive=function(Gstarsamples){
                                     quantile(Gstarsamples,prob=0.5)})
##specified the design
design <- DualResponsesSamplesDesign(nextBest=mynextbest,
                                     cohortSize=mySize,
                                     startingDose=25,
                                     model=DLEmodel,
                                     Effmodel=Effmodel,
                                     data=data,
                                     stopping=myStopping,
                                     increments=myIncrements)
##options for MCMC
##For illustration purpose, we will use 50 burn-ins to generate 200 samples
options<-McmcOptions(burnin=50,step=2,samples=200)
##The simulations
##For illustration purpose only 2 simulation is produced (nsim=2). 
mySim<-simulate(design,
                args=NULL,
                trueDLE=myTruthDLE,
                trueEff=myTruthEff,
                trueNu=1/0.025,
                nsim=2,
                mcmcOptions=options,
                seed=819,
                parallel=FALSE)

##Then produce a summary of your simulations
summary(mySim,
        trueDLE=myTruthDLE,
        trueEff=myTruthEff)

}
\keyword{methods}
