% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticLogNormalSub-class}
\alias{.LogisticLogNormalSub}
\alias{LogisticLogNormalSub-class}
\title{Standard logistic model with bivariate (log) normal prior with substractive
dose standardization}
\description{
This is the usual logistic regression model with a bivariate normal prior on
the intercept and log slope.
}
\details{
The covariate is the dose \eqn{x} minus the reference dose \eqn{x^{*}}:

\deqn{logit[p(x)] = \alpha + \beta \cdot (x - x^{*})}
where \eqn{p(x)} is the probability of observing a DLT for a given dose
\eqn{x}.

The prior is
\deqn{(\alpha, \log(\beta)) \sim Normal(\mu, \Sigma)}

The slots of this class contain the mean vector and the covariance matrix of
the bivariate normal distribution, as well as the reference dose.
}
\section{Slots}{

\describe{
\item{\code{mean}}{the prior mean vector \eqn{\mu}}

\item{\code{cov}}{the prior covariance matrix \eqn{\Sigma}}

\item{\code{refDose}}{the reference dose \eqn{x^{*}}}
}}
\examples{


model <- LogisticLogNormalSub(mean = c(-0.85, 1),
                           cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
                           refDose = 50)


}
\keyword{classes}

