% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{IncrementsRelative-class}
\alias{.IncrementsRelative}
\alias{IncrementsRelative-class}
\title{Increments control based on relative differences in intervals}
\description{
Note that \code{intervals} is to be read as follows. If for example,
we want to specify three intervals: First 0 to less than 50, second at least
50 up to less than 100 mg, and third at least 100 mg, then we specify
\code{intervals} to be \code{c(0, 50, 100)}. That means, the right
bound of the intervals are exclusive to the interval, and the last interval
goes from the last value until infinity.
}
\section{Slots}{

\describe{
\item{\code{intervals}}{a vector with the left bounds of the relevant intervals}

\item{\code{increments}}{a vector of the same length with the maximum allowable
relative increments in the \code{intervals}}
}}
\examples{

# As example, here is the rule for: 
#   maximum doubling the dose if the current dose is <20
#   OR only maximum increasing the dose by 1.33 if the current dose is >=20

myIncrements <- IncrementsRelative(intervals=c(0, 20),
                                   increments=c(1, 0.33))

}
\keyword{classes}

