% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher.R
\name{crew_class_launcher}
\alias{crew_class_launcher}
\title{Launcher abstract class}
\description{
\code{R6} abstract class to build other subclasses
which launch and manage workers.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
launcher <- crew_launcher_local()
launcher$start(url = client$url, profile = client$profile)
launcher$launch()
task <- mirai::mirai("result", .compute = client$profile)
mirai::call_mirai(task)
task$data
client$terminate()
}

## ------------------------------------------------
## Method `crew_class_launcher$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
launcher <- crew_launcher_local()
launcher$start(url = client$url, profile = client$profile)
launcher$launch()
task <- mirai::mirai("result", .compute = client$profile)
mirai::call_mirai(task)
task$data
client$terminate()
}

## ------------------------------------------------
## Method `crew_class_launcher$call`
## ------------------------------------------------

launcher <- crew_launcher_local()
launcher$start(url = "tcp://127.0.0.1:57000", profile = "profile")
launcher$call(worker = "worker_name")
launcher$terminate()
}
\seealso{
Other launcher: 
\code{\link{crew_launcher}()}
}
\concept{launcher}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{workers}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_globals}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_packages}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_options}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{garbage_collection}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tls}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{processes}}{See \code{\link[=crew_launcher]{crew_launcher()}}.
asynchronously.}

\item{\code{r_arguments}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{options_metrics}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{url}}{Websocket URL for worker connections.}

\item{\code{profile}}{\code{mirai} compute profile of the launcher.}

\item{\code{instances}}{Data frame of worker instance information.}

\item{\code{id}}{Integer worker ID from the last call to \code{settings()}.}

\item{\code{async}}{A \code{\link[=crew_async]{crew_async()}} object to run low-level launcher tasks
asynchronously.}

\item{\code{throttle}}{A \code{\link[=crew_throttle]{crew_throttle()}} object to throttle scaling.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_launcher-new}{\code{crew_class_launcher$new()}}
\item \href{#method-crew_class_launcher-validate}{\code{crew_class_launcher$validate()}}
\item \href{#method-crew_class_launcher-poll}{\code{crew_class_launcher$poll()}}
\item \href{#method-crew_class_launcher-settings}{\code{crew_class_launcher$settings()}}
\item \href{#method-crew_class_launcher-call}{\code{crew_class_launcher$call()}}
\item \href{#method-crew_class_launcher-start}{\code{crew_class_launcher$start()}}
\item \href{#method-crew_class_launcher-terminate}{\code{crew_class_launcher$terminate()}}
\item \href{#method-crew_class_launcher-resolve}{\code{crew_class_launcher$resolve()}}
\item \href{#method-crew_class_launcher-update}{\code{crew_class_launcher$update()}}
\item \href{#method-crew_class_launcher-launch}{\code{crew_class_launcher$launch()}}
\item \href{#method-crew_class_launcher-scale}{\code{crew_class_launcher$scale()}}
\item \href{#method-crew_class_launcher-launch_worker}{\code{crew_class_launcher$launch_worker()}}
\item \href{#method-crew_class_launcher-terminate_worker}{\code{crew_class_launcher$terminate_worker()}}
\item \href{#method-crew_class_launcher-terminate_workers}{\code{crew_class_launcher$terminate_workers()}}
\item \href{#method-crew_class_launcher-crashes}{\code{crew_class_launcher$crashes()}}
\item \href{#method-crew_class_launcher-set_name}{\code{crew_class_launcher$set_name()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-new}{}}}
\subsection{Method \code{new()}}{
Launcher constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$new(
  name = NULL,
  workers = NULL,
  seconds_interval = NULL,
  seconds_timeout = NULL,
  seconds_launch = NULL,
  seconds_idle = NULL,
  seconds_wall = NULL,
  seconds_exit = NULL,
  tasks_max = NULL,
  tasks_timers = NULL,
  reset_globals = NULL,
  reset_packages = NULL,
  reset_options = NULL,
  garbage_collection = NULL,
  crashes_error = NULL,
  launch_max = NULL,
  tls = NULL,
  processes = NULL,
  r_arguments = NULL,
  options_metrics = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{workers}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_exit}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_globals}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_packages}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_options}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{garbage_collection}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{crashes_error}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{launch_max}}{Deprecated.}

\item{\code{tls}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{processes}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{r_arguments}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{options_metrics}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the launcher.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
launcher <- crew_launcher_local()
launcher$start(url = client$url, profile = client$profile)
launcher$launch()
task <- mirai::mirai("result", .compute = client$profile)
mirai::call_mirai(task)
task$data
client$terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the launcher.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-poll"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-poll}{}}}
\subsection{Method \code{poll()}}{
Poll the throttle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$poll()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} to run whatever work comes next, \code{FALSE} to skip
until the appropriate time.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-settings"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-settings}{}}}
\subsection{Method \code{settings()}}{
List of arguments for \code{mirai::daemon()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$settings()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of arguments for \code{mirai::daemon()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-call"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-call}{}}}
\subsection{Method \code{call()}}{
Create a call to \code{\link[=crew_worker]{crew_worker()}} to
help create custom launchers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$call(
  worker,
  socket = NULL,
  launcher = NULL,
  instance = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{worker}}{Character string, name of the worker.}

\item{\code{socket}}{Deprecated on 2025-01-28 (\code{crew} version 1.0.0).}

\item{\code{launcher}}{Deprecated on 2025-01-28 (\code{crew} version 1.0.0).}

\item{\code{instance}}{Deprecated on 2025-01-28 (\code{crew} version 1.0.0).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character string with a call to \code{\link[=crew_worker]{crew_worker()}}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{launcher <- crew_launcher_local()
launcher$start(url = "tcp://127.0.0.1:57000", profile = "profile")
launcher$call(worker = "worker_name")
launcher$terminate()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-start}{}}}
\subsection{Method \code{start()}}{
Start the launcher.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$start(url = NULL, profile = NULL, sockets = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{Character string, websocket URL for worker connections.}

\item{\code{profile}}{Character string, \code{mirai} compute profile.}

\item{\code{sockets}}{Deprecated on 2025-01-28 (\code{crew} version 1.0.0).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate the whole launcher, including all workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$terminate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-resolve"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-resolve}{}}}
\subsection{Method \code{resolve()}}{
Resolve asynchronous worker submissions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$resolve()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly). Throw an error if there were any
asynchronous worker submission errors.'
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-update"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-update}{}}}
\subsection{Method \code{update()}}{
Update worker metadata, resolve asynchronous
worker submissions, and terminate lost workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$update(status)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{A \code{mirai} status list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-launch}{}}}
\subsection{Method \code{launch()}}{
Launch a worker.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$launch()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Handle of the launched worker.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-scale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-scale}{}}}
\subsection{Method \code{scale()}}{
Auto-scale workers out to meet the demand of tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$scale(status, throttle = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{A \code{mirai} status list with worker and task information.}

\item{\code{throttle}}{Deprecated, only used in the controller
as of 2025-01-16 (\code{crew} version 0.10.2.9003).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly returns \code{TRUE} if there was any relevant
auto-scaling activity (new worker launches or worker
connection/disconnection events) (\code{FALSE} otherwise).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-launch_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-launch_worker}{}}}
\subsection{Method \code{launch_worker()}}{
Abstract worker launch method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$launch_worker(call, name, launcher, worker)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{call}}{Character of length 1 with a namespaced call to
\code{\link[=crew_worker]{crew_worker()}} which will run in the worker and accept tasks.}

\item{\code{name}}{Character of length 1 with an informative worker name.}

\item{\code{launcher}}{Character of length 1, name of the launcher.}

\item{\code{worker}}{Positive integer of length 1, index of the worker.
This worker index remains the same even when the current instance
of the worker exits and a new instance launches.
It is always between 1 and the maximum number of concurrent workers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Launcher plugins will overwrite this method.
}

\subsection{Returns}{
A handle to mock the worker launch.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-terminate_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-terminate_worker}{}}}
\subsection{Method \code{terminate_worker()}}{
Abstract worker termination method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$terminate_worker(handle)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handle}}{A handle object previously
returned by \code{launch_worker()} which allows the termination
of the worker.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Launcher plugins will overwrite this method.
}

\subsection{Returns}{
A handle to mock worker termination.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-terminate_workers"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-terminate_workers}{}}}
\subsection{Method \code{terminate_workers()}}{
Terminate all workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$terminate_workers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-crashes"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-crashes}{}}}
\subsection{Method \code{crashes()}}{
Deprecated on 2025-01-28 (\code{crew} version 1.0.0).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$crashes(index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{Unused argument.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The integer 1, for compatibility.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-set_name"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-set_name}{}}}
\subsection{Method \code{set_name()}}{
Deprecated on 2025-01-28 (\code{crew} version 1.0.0).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$set_name(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name to set for the launcher.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
